package cn.com.duiba.activity.center.biz.dao;



import com.google.common.base.Preconditions;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * 泛型CURD抽象基类
 * @author jyc
 * @since 2016-09-05
 */
public abstract class AbstractGenericCURDDao <E,PK> extends ActivityBaseDao implements GenericCURDDao<E,PK> {


    // 语句常量定义

    protected static final String INSERT="insert";
    protected static final String DELETE="delete";
    protected static final String UPDATE="update";
    protected static final String QUERY="query";
    protected static final String QUERY_BY_ID="queryById";

    @Override
    public E queryById(PK id){
        Preconditions.checkNotNull(id);
        E entity=selectOne(QUERY_BY_ID,id);
        return entity;
    }
    @Override
    public int delete(PK id){
        return this.delete(DELETE,id);
    }

    @Override
    public int insert(E record){
        return this.insert(INSERT,record);
    }

    /*
    @Override
    public List<E> query(E condition){
        return selectList(QUERY, condition);
    }
    */
    @Override
    public int update(E record){
        return this.update(UPDATE,record);
    }

}
