package cn.com.duiba.activity.center.biz.dao.activity_brick.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.activity_brick.PopupActivityBrickDao;
import cn.com.duiba.activity.center.biz.entity.activity_brick.PopupActivityBrickEntity;
import cn.com.duiba.wolf.utils.BeanUtils;

/** 
 * ClassName:PopupActivityBrickDaoImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月12日 下午3:13:15 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */

@Repository
public class PopupActivityBrickDaoImpl extends ActivityBaseDao implements
		PopupActivityBrickDao {

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_ACTIVITY;
	}

	@Override
	public PopupActivityBrickDto insert(PopupActivityBrickDto brick) {
		PopupActivityBrickEntity entity =new PopupActivityBrickEntity(true);
		BeanUtils.copy(brick,entity);
		insert("insert", entity);
		brick.setId(entity.getId());
		return brick;
	}

	@Override
	public Integer update(PopupActivityBrickDto brick) {
		PopupActivityBrickEntity entity =new PopupActivityBrickEntity(brick.getId());
		BeanUtils.copy(brick,entity);
		return update("update",entity);
	}

	@Override
	public PopupActivityBrickDto findById(Long id) {
		return BeanUtils.copy(selectOne("findById",id), PopupActivityBrickDto.class);
	}

	@Override
	public Integer deleteById(Long id) {
		PopupActivityBrickEntity entity =new PopupActivityBrickEntity(Long.valueOf(id));
		entity.setDeleted(1);
		return update("update",entity);
	}

	@Override
	public Integer showBrick(Long id) {
		PopupActivityBrickEntity entity =new PopupActivityBrickEntity(Long.valueOf(id));
		entity.setStatus(1);
		return update("update",entity);
	}

	@Override
	public Integer hiddenBrick(Long id) {
		PopupActivityBrickEntity entity =new PopupActivityBrickEntity(Long.valueOf(id));
		entity.setStatus(0);
		return update("update",entity);
	}

	@Override
	public List<PopupActivityBrickDto> findPage(Map<String, Object> paramMap) {
		return BeanUtils.copyList(selectList("findByPage", paramMap), PopupActivityBrickDto.class);
	}

	@Override
	public Long findPageCount(Map<String, Object> paramMap) {
		return selectOne("findPageCount",paramMap);
	}

}
