package cn.com.duiba.activity.center.biz.dao.creditgame.impl;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.biz.dao.CreditGameBaseDao;
import cn.com.duiba.activity.center.biz.dao.creditgame.CreditGameDao;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameEntity;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;


@Repository
public class CreditGameDaoImpl extends CreditGameBaseDao<CreditGameEntity, Long> implements CreditGameDao {

    @Override
    public List<CreditGameEntity> selectList(String title, Integer offset, Integer max) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("title", title);
        params.put("offset", offset);
        params.put("max", max);
        return selectList("selectList",params);
    }

    @Override
    public Long selectCount(String title) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("title", title);
        return selectOne("selectCount",params);
    }

    @Override
    public List<Long> selectAutoOff() {
        return selectList("selectAutoOff");
    }
}