package cn.com.duiba.activity.center.biz.dao.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadDataSource {

    private static final Logger        log        = LoggerFactory.getLogger(ReadDataSource.class);

    protected static List<ReadDataSource> readonlyDatasource;
    public static final String         MASTER     = "dataSource";
    public static final String         READ_1     = "readOnly1";
    public static final String         READ_2     = "readOnly2";

    private String                     dataSource = "dataSource";
    private boolean                    down       = false;

    static {
        readonlyDatasource = new ArrayList<ReadDataSource>();
        ReadDataSource readOnly1 = new ReadDataSource();
        readOnly1.setDataSource(READ_1);
        readonlyDatasource.add(readOnly1);
        ReadDataSource readOnly2 = new ReadDataSource();
        readOnly2.setDataSource(READ_2);
        readonlyDatasource.add(readOnly2);
    }

    public static String getReadOnlyDateSource() {
        try {
            List<ReadDataSource> activeReadSource = new ArrayList<ReadDataSource>();
            for (ReadDataSource source : readonlyDatasource) {
                if (!source.isDown()) {
                    activeReadSource.add(source);
                }
            }
            ReadDataSource dataSource = getServer(activeReadSource);
            if (dataSource == null) {
                return MASTER;
            }
            return dataSource.getDataSource();
        } catch (Exception e) {
            log.error("getReadOnlyDateSource :", e);
        }
        return MASTER;
    }

    private static AtomicLong index = new AtomicLong(0);

    public static ReadDataSource getServer(List<ReadDataSource> activeDataSource) {
        if (activeDataSource == null || activeDataSource.size() < 1) {
            return null;
        }
        long value = index.getAndIncrement();
        int i = (int) (value % activeDataSource.size());
        return activeDataSource.get(i);
    }

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isDown() {
        return down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

}
