package cn.com.duiba.activity.center.biz.dao.direct.impl;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.direct.DeveloperActivityBlackDao;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DeveloperActivityBlackDaoImpl extends ActivityBaseDao implements DeveloperActivityBlackDao {

    @Override
    public int insert(ActivityBlackList4DeveloperDto black) {
        return insert("insert", black);
    }

    @Override
    public int insertList(List<ActivityBlackList4DeveloperDto> blacks) {
        return insert("insertList", blacks);
    }

    @Override
    public int remove(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return delete("remove", id);
    }

    @Override
    public ActivityBlackList4DeveloperDto find(Long id) {
        return selectOne("find", id);
    }

    @Override
    public List<ActivityBlackList4DeveloperDto> queryByActivity(Map<String, Object> paramMap) {
        return selectList("queryByActivity", paramMap);
    }

    @Override
    public int queryCountByActivity(Long activityId, Integer activityType) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("activityType", activityType);
        return selectOne("queryCountByActivity", paramMap);
    }

    @Override
    public int query(ActivityBlackList4DeveloperDto black) {
        return selectOne("query", black);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
