package cn.com.duiba.activity.center.biz.dao.game;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.game.GameOrdersEntity;
import cn.com.duiba.activity.center.biz.entity.game.GameOrdersSimpleEntity;

public interface GameOrdersSimpleDao {

	public GameOrdersEntity find(Long gameOrderId);

	public GameOrdersEntity findByAppAndDeveloperBizId(Long appId, String bizId);

	public List<GameOrdersEntity> findByIds(List<Long> ids);

	public void insert(GameOrdersEntity gameOrdersSimpleEntity);

	public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId);

	public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId);

	public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	public Integer countConsumerByPrizeId(Long consumerId, Long operatingActivityId, Long prizeId);

	public Integer countConsumerByGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId);

	public List<Long> findOverdueOrder();

	public Long countRow(Map<String, Object> params);

	public List<GameOrdersSimpleEntity> findByLimit(Map<String, Object> params);

	public List<DeveloperActivityStatisticsEntity> countFailByOperatingActivityIds(List<Long> ids);

}
