package cn.com.duiba.activity.center.biz.dao.game.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DevelopQuestionRecordDao;
import cn.com.duiba.activity.center.biz.entity.game.QuestionRecordEntity;

@Repository
public class DevelopQuestionRecordDaoImpl extends ActivityBaseDao implements DevelopQuestionRecordDao {

	@Override
	public List<QuestionRecordEntity> findByQuestionRecordId(Long activityId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("activityId", activityId);
		return selectList("findByQuestionRecordId", paramMap);
	}

	@Override
	public void updateRecordDeleteStatus(List<Long> oaoIds) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("oaoIds", oaoIds);
		delete("updateRecordDeleteStatus", paramMap);
	}

	@Override
	public void insertRecord(QuestionRecordEntity recordDto) {
		insert("insertRecord", recordDto);
	}

	@Override
	public void updateRecord(QuestionRecordEntity recordDto) {
		update("updateRecord", recordDto);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}

}
