package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessAppSpecifyEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaGuessAppSpecifyDaoImpl extends ActivityBaseDao implements DuibaGuessAppSpecifyDao {

	@Override
	public List<DuibaGuessAppSpecifyEntity> findByDuibaGuessId(Long duibaGuessId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaGuessId", duibaGuessId);
		return selectList("findByDuibaGuessId", paramMap);
	}

	@Override
	public void delete(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		delete("delete", paramMap);
	}

	@Override
	public void insert(DuibaGuessAppSpecifyEntity duibaGuessAppSpecify) {
		insert("insert", duibaGuessAppSpecify);
	}

	@Override
	public DuibaGuessAppSpecifyEntity findByDuibaGuessAndApp(Long duibaGuessId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaGuessId", duibaGuessId);
		paramMap.put("appId", appId);
		return selectOne("findByDuibaGuessAndApp", paramMap);
	}

	@Override
	public DuibaGuessAppSpecifyEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.GUESS;
	}
}
