package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessBrickDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessBrickEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/7/18.
 */
@Repository
public class DuibaGuessBrickDaoImpl extends ActivityBaseDao implements DuibaGuessBrickDao {
    @Override
    public DuibaGuessBrickEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    @Override
    public String getBrickContentById(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("getBrickContentById", paramMap);
    }

    @Override
    public DuibaGuessBrickEntity findNoContent(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findNoContent", paramMap);
    }

    @Override
    public String getBrickPrizeContentById(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("getBrickPrizeContentById", paramMap);
    }

    @Override
    public void insert(DuibaGuessBrickEntity duibaGuessBrick) {
        insert("insert", duibaGuessBrick);
    }

    @Override
    public void update4Admin(Long id, String title, String content,String prizeContent, String md5) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("title", title);
        paramMap.put("content", content);
        paramMap.put("prizeContent", prizeContent);
        paramMap.put("md5", md5);
        update("update4Admin", paramMap);

    }

    @Override
    public DuibaGuessBrickEntity findByTitle(String title) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("title", title);
        return selectOne("findByTitle", paramMap);
    }

    @Override
    public void open(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        update("open", paramMap);
    }

    @Override
    public void disable(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        update("disable", paramMap);
    }

    @Override
    public List<DuibaGuessBrickEntity> findPage(Integer offset, Integer max) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        return selectList("findPage", paramMap);
    }

    @Override
    public Long findPageCount() {
        return selectOne("findPageCount");
    }

    @Override
    public List<DuibaGuessBrickEntity> findAll() {
        return selectList("findAll");
    }

    /**
     * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
     *
     * @return
     */
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.GUESS;
    }
}
