package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessStockManualChangeDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessStockManualChangeEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("duibaGuessStockManualChangeDAO")
public class DuibaGuessStockManualChangeDaoImpl extends ActivityBaseDao implements DuibaGuessStockManualChangeDao {

	@Override
	public List<DuibaGuessStockManualChangeEntity> findByStockId(Long guessStockId) {
		return selectList("findByStockId", guessStockId);
	}

	@Override
	public void addBatch(List<DuibaGuessStockManualChangeEntity> list) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("list", list);
		insert("addBatch", params);
	}

	@Override
	public void add(DuibaGuessStockManualChangeEntity guessStockManualChangeDO) {
		insert("add", guessStockManualChangeDO);
	}

	/**
	 * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
	 *
	 * @return
	 */
	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.GUESS;
	}
}
