package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrderTextChangeDao;
import cn.com.duiba.activity.center.biz.entity.guess.GuessOrdersEntity;

import org.springframework.stereotype.Repository;

import java.util.Map;

import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;

/**
 * Created by yansen on 16/7/18.
 */
@Repository
public class GuessOrderTextChangeDaoImpl extends ActivityBaseDao implements GuessOrderTextChangeDao {


    @Override
    public Integer insert(GuessOrdersEntity guessOrdersEntity, Long id) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(guessOrdersEntity.getConsumerId());
        guessOrdersEntity.setId(id);
        paramMap.put("mirror", guessOrdersEntity);
        int ret = insert("insert", paramMap);
        return ret;
    }
    
    /**
     * 根据ID查询订单
     */
    public GuessOrdersEntity find(Long consumerId, Long id) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    /**
     * 修改开发者订单号
     */
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("bizId", bizId);
        int ret = update("updateDeveloperBizId", paramMap);
        return ret;
    }


    /**
     * 修改抽奖订单主订单号
     */
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("mainOrderId", mainOrderId);
        paramMap.put("mainOrderNum", mainOrderNum);
        int ret = update("updateMainOrderId", paramMap);
        return ret;
    }

    /**
     * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
     *
     * @return
     */
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.GUESS_CON;
    }
}
