package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersDao;
import cn.com.duiba.activity.center.biz.entity.guess.GuessOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.*;

@Repository
public class GuessOrdersDaoImpl extends ActivityBaseDao implements GuessOrdersDao {
	
	@Override
	public void insert(GuessOrdersEntity guessOrdersEntity){
		insert("insert", guessOrdersEntity);
	}

    @Override
    public List<GuessOrdersEntity> findWinByGuessIdAndPrizeId(Long duibaGuessId, Long prizeId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("guessId", duibaGuessId);
        paramMap.put("prizeId", prizeId);
        return selectList("findWinByGuessIdAndPrizeId", paramMap);
    }

    @Override
    public List<GuessOrdersEntity> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaGuessId", duibaGuessId);
        paramMap.put("winIds", winIds);
        paramMap.put("guessData", guessData);
        return selectList("findWinOrderByExactMatch", paramMap);
    }

    @Override
    public List<GuessOrdersEntity> findWinOrderByVagueMatch(Long duibaGuessId,int num, String luckNum, String guessData) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaGuessId", duibaGuessId);
        paramMap.put("luckNum", luckNum);
        paramMap.put("guessData", guessData);
        paramMap.put("size", num);
        return selectList("findWinOrderByVagueMatch", paramMap);
    }

    @Override
    public List<GuessOrdersEntity> findExpireOrder() {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.DATE, -7);
        Date startTime = cal.getTime();
        paramMap.put("startPrizeOverdueDate", startTime);
        paramMap.put("endPrizeOverdueDate", new Date());
        paramMap.put("exchangeStatus", GuessOrdersDto.ExchangeStatusWait);
        return selectList("findExpireOrder", paramMap);
    }

    @Override
    public List<GuessOrdersEntity> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData, Integer offset, Integer max, Long consumerId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaGuessId", duibaGuessId);
        paramMap.put("winIds", winIds);
        paramMap.put("guessData", guessData);
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        paramMap.put("consumerId", consumerId);
        return selectList("findWinOrderByExactMatch2", paramMap);
    }

    @Override
    public List<GuessOrdersEntity> findWinOrderByVagueMatch(Long duibaGuessId,int num, String luckNum, String guessData, Integer offset, Integer max, Long consumerId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaGuessId", duibaGuessId);
        paramMap.put("luckNum", luckNum);
        paramMap.put("guessData", guessData);
        paramMap.put("size", num);
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        paramMap.put("consumerId", consumerId);
        return selectList("findWinOrderByVagueMatch2", paramMap);
    }

    /**
     * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
     *
     * @return
     */
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.GUESS;
    }
}

