package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersExtraDao;
import cn.com.duiba.activity.center.biz.entity.guess.GuessOrdersExtraEntity;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class GuessOrdersExtraDaoImpl extends ActivityBaseDao implements GuessOrdersExtraDao {

    @Override
    public GuessOrdersExtraEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    @Override
    public void insert(GuessOrdersExtraEntity guessOrdersExtraDO) {
        insert("insert", guessOrdersExtraDO);
    }

    @Override
    public int updateOrderId(Long id, Long mainOrderId, String mainOrderNum) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("mainOrderId", mainOrderId);
        paramMap.put("mainOrderNum", mainOrderNum);
        return update("updateOrderId", paramMap);
    }

    @Override
    public List<Long> findWiningPrizeIds(Long consumerId, Long duibaGuessId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("consumerId", consumerId);
        paramMap.put("duibaGuessId", duibaGuessId);
        return selectList("findWiningPrizeIds", paramMap);
    }

    @Override
    public void updateNotPrize(Long guessExtraOrderId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", guessExtraOrderId);
        selectOne("updateNotPrize", paramMap);
    }

    /**
     * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
     *
     * @return
     */
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.GUESS;
    }
}
