package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.GuessStockConsumeDao;
import cn.com.duiba.activity.center.biz.entity.guess.GuessStockConsumeEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Repository("guessStockConsumeDAO")
public class GuessStockConsumeDaoImpl extends ActivityBaseDao implements GuessStockConsumeDao {

	@Override
	public GuessStockConsumeEntity findByBizId(Long stockId, String bizId, String action) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("bizId", bizId);
		paramMap.put("action", action);
		paramMap.put("stockId", stockId);
		return selectOne("findByBizId", paramMap);
	}

	@Override
	public void insert(GuessStockConsumeEntity GuessStockConsumeEntity) {
		insert("insert", GuessStockConsumeEntity);
	}

	/**
	 * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
	 *
	 * @return
	 */
	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.GUESS;
	}
}
