package cn.com.duiba.activity.center.biz.dao.hdtool;

import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolSkinDefaultEntity;

import java.util.List;


/**
 * Created by yansen on 16/7/5.
 */
public interface HdtoolDefaultSkinDataDao {
    /**
     * 插入一条默认皮肤样式
     * @author zp
     * @param hdtoolSkinDefaultDataDO
     * @since JDK 1.6
     */
    public void insert(HdtoolSkinDefaultEntity hdtoolSkinDefaultEntity);

    /**
     * 更新默认配置数据，或默认配置样式
     * @author zp
     * @param hdtoolSkinDefaultDataDO
     * @return
     * @since JDK 1.6
     */
    public int updateData(HdtoolSkinDefaultEntity hdtoolSkinDefaultEntity);

    /**
     * 查询默认基础配置
     * @author zp
     * @param templateType
     * @param type
     * @return
     * @since JDK 1.6
     */
    public HdtoolSkinDefaultEntity selectBaseHdtoolData(String templateType,String type);

    /**
     * 查询默认数据配置和默认数据样式
     * @author zp
     * @param templateType
     * @param type
     * @return
     * @since JDK 1.6
     */
    public HdtoolSkinDefaultEntity selectConfigAndStyleData(String templateType,String type);

    /**
     * 分页查询
     * @author zp
     * @param offset
     * @param max
     * @return
     * @since JDK 1.6
     */
    public List<HdtoolSkinDefaultEntity> selectAllByPagination(Integer offset, Integer max);

    /**
     * 查询总条数
     * @author zp
     * @return
     * @since JDK 1.6
     */
    public Integer selectAllByPaginationCount();
}
