package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameBrickDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameBrickEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaNgameBrickDaoImpl extends ActivityBaseDao implements DuibaNgameBrickDao {

	@Override
	public DuibaNgameBrickEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public void insert(DuibaNgameBrickEntity duibaNgameBrickDto) {
		insert("insert", duibaNgameBrickDto);
	}

	@Override
	public void update4Admin(DuibaNgameBrickEntity duibaNgameBrickDto) {
		update("update4Admin", duibaNgameBrickDto);

	}

	@Override
	public DuibaNgameBrickEntity findByTitle(String title) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("title", title);
		return selectOne("findByTitle", paramMap);
	}

	@Override
	public void open(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("open", paramMap);
	}

	@Override
	public void disable(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("disable", paramMap);
	}

	@Override
	public List<DuibaNgameBrickEntity> findPage(Integer offset, Integer max) {
		Map<String, Object> paramMap = Maps.newHashMap();
		paramMap.put("offset", offset);
		paramMap.put("max", max);
		return selectList("findPage", paramMap);
	}

	@Override
	public Long findPageCount() {
		return selectOne("findPageCount");
	}

	@Override
	public List<DuibaNgameBrickEntity> findAll() {
		return selectList("findAll");
	}

	@Override
	public String getBrickContentById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("getBrickContentById", paramMap);
	}

	@Override
	public DuibaNgameBrickEntity findNoContent(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findNoContent", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
