package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameConsumerRecordDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameConsumerRecordEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class NgameConsumerRecordDaoImpl extends ActivityBaseDao implements NgameConsumerRecordDao {

	@Override
	public NgameConsumerRecordEntity findRecordByConIdAndNgameId(Long consumerId, Long duibaNgameId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("consumerId", consumerId);
		paramMap.put("duibaNgameId", duibaNgameId);
		return selectOne("findRecordByConIdAndNgameId", paramMap);
	}

	@Override
	public void insert(NgameConsumerRecordEntity gameConsumerRecordDO) {
		insert("insert", gameConsumerRecordDO);
	}

	@Override
	public Integer updateScore(Long id, Long score, String autoOpenPrizeId, Long gameOrderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("score", score);
		paramMap.put("autoOpenPrizeId", autoOpenPrizeId);
		paramMap.put("gameOrderId", gameOrderId);
		return update("updateScore2", paramMap);
	}

	@Override
	public List<NgameConsumerRecordEntity> findGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaNgameId", duibaNgameId);
		paramMap.put("number", number);
		return selectList("findGameConfigDuibaScoreByDesc", paramMap);
	}
	@Override
	public List<NgameConsumerRecordEntity> findGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaNgameId", duibaNgameId);
		paramMap.put("number", number);
		return selectList("findGameConfigDuibaScoreByAsc", paramMap);
	}
	
	@Override
	public List<NgameConsumerRecordEntity> findConsumerGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaNgameId", duibaNgameId);
		paramMap.put("number", number);
		return selectList("findConsumerGameConfigDuibaScoreByDesc", paramMap);
	}
	@Override
	public List<NgameConsumerRecordEntity> findConsumerGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaNgameId", duibaNgameId);
		paramMap.put("number", number);
		return selectList("findConsumerGameConfigDuibaScoreByAsc", paramMap);
	}

	@Override
	public Integer updateIsGivePrize(Long id, Boolean isGivePrize) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("isGivePrize", isGivePrize);
		return update("updateIsGivePrize", paramMap);
	}

	@Override
	public Integer updateTotalScore(Long id, Integer shareScore) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("shareScore", shareScore);
		return update("updateTotalScore", paramMap);
	}

	@Override
	public Integer updateScoreAndTotalScore(Long id, Long score, Integer shareScore, String autoOpenPrizeId, Long gameOrderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("score", score);
		paramMap.put("shareScore", shareScore);
		paramMap.put("autoOpenPrizeId", autoOpenPrizeId);
		paramMap.put("gameOrderId", gameOrderId);
		return update("updateScoreAndTotalScore", paramMap);
	}
	
	@Override
	public Integer updateAutoOpenPrizeId(Long id, String autoOpenPrizeId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("autoOpenPrizeId", autoOpenPrizeId);
		return update("updateAutoOpenPrizeId", paramMap);
	}

	@Override
	public void markCheat(Long id, Boolean cheat) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("id", id);
		params.put("cheat", cheat);
		update("markCheat", params);		
	}

	@Override
	public List<NgameConsumerRecordEntity> findByConsumerAndIds(Long consumerId, List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("consumerId", consumerId);
		paramMap.put("ids", ids);
		return selectList("findByConsumerAndIds", paramMap);
	}


	@Override
	public List<NgameConsumerRecordEntity> findTopWinning(Map<String, Object> params) {
		return selectList("findTopWinning", params);
	}

	@Override
	public List<NgameConsumerRecordEntity> findTopWinningAsc(Map<String, Object> params) {
		return selectList("findTopWinningAsc", params);
	}

	@Override
	public Integer countCheatBefore(Integer limit, Long gameConfigDuibaId) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("limit", limit);
		params.put("gameConfigDuibaId", gameConfigDuibaId);
		return selectOne("countCheatBefore", params);
	}

	@Override
	public Integer countTopWinning(Map<String, Object> params) {
		return selectOne("countTopWinning", params);
	}

	@Override
	public NgameConsumerRecordEntity find(Long id) {
		return selectOne("find", id);
	}

	@Override
	public void setCheatReason(Long id, String cheatReason) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("id", id);
		params.put("cheatReason", cheatReason);
		update("setCheatReason", params);
	}

	@Override
	public List<NgameConsumerRecordEntity> findShareConsumerByGameConfigDuibaId(
			Long duibaNgameId) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("duibaNgameId", duibaNgameId);
		return selectList("findShareConsumerByGameConfigDuibaId", params);
	}

	@Override
	public int updateByGameConfigShare(Long id, Long duibaNgameId,
									   Long shareScore) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("id", id);
		params.put("shareScore", shareScore);
		params.put("duibaNgameId", duibaNgameId);
		return update("updateByGameConfigShare", params);
	}

	@Override
	public NgameConsumerRecordEntity findByConsumerIdAndGameConfigDuibaId(Long consumerId,
																	   Long gameConfigDuibaId) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("consumerId", consumerId);
		params.put("gameConfigDuibaId", gameConfigDuibaId);
		return selectOne("findByConsumerIdAndGameConfigDuibaId", params);
	}
	
	@Override
    public void updateScore(Long id, Long score) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("id", id);
        params.put("score", score);
        update("updateScore", params);
    }

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
