package cn.com.duiba.activity.center.biz.dao.plugin.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.plugin.ActivityPluginDao;
import cn.com.duiba.activity.center.biz.entity.plugin.ActivityPluginEntity;
import cn.com.duiba.wolf.utils.BeanUtils;

/** 
 * ClassName:ActivityPluginDaoImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月11日 下午4:37:21 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Repository
public class ActivityPluginDaoImpl extends ActivityBaseDao implements ActivityPluginDao {

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_ACTIVITY;
	}

	@Override
	public ActivityPluginDto createActivityPluginInfo(ActivityPluginDto activityPluginDto) {
		ActivityPluginEntity entity=new ActivityPluginEntity(true);
		BeanUtils.copy(activityPluginDto,entity);
		insert("createActivityPluginInfo", entity);
		activityPluginDto.setId(entity.getId());
		return activityPluginDto;
	}

	@Override
	public Integer updateActivityPluginInfo(ActivityPluginDto activityPluginDto) {
		ActivityPluginEntity entity=new ActivityPluginEntity(activityPluginDto.getId());
		BeanUtils.copy(activityPluginDto,entity);
		return update("updateActivityPluginInfo",entity);
	}

	@Override
	public ActivityPluginDto findById(Long id) {
		return BeanUtils.copy(selectOne("findById", id), ActivityPluginDto.class);
	}

	@Override
	public Integer OpenStatus(Long id,Integer value) {
		ActivityPluginEntity entity=new ActivityPluginEntity(id);
		entity.setStatus(value);
		return update("updateActivityPluginInfo",entity);
	}

	@Override
	public List<ActivityPluginDto> findActivityPluginInfoList(Map<String, Object> map) {
		return BeanUtils.copyList(selectList("findByPage", map), ActivityPluginDto.class);
	}

	@Override
	public Long findPageCount(Map<String, Object> paramMap) {
		return selectOne("findPageCount",paramMap);
	}

	@Override
	public Integer dellActivityPlugin(Long id) {
		ActivityPluginEntity entity=new ActivityPluginEntity(id);
		entity.setDeleted(1);
		return update("updateActivityPluginInfo",entity);
	}

}