package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.*;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzAppSpecifyEntity;
import org.springframework.stereotype.Repository;


@Repository
public class DuibaQuizzAppSpecifyDaoImpl extends ActivityBaseDao implements DuibaQuizzAppSpecifyDao {

	@Override
	public List<DuibaQuizzAppSpecifyEntity> findByDuibaQuizzId(Long duibaQuizzId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaQuizzId", duibaQuizzId);
		return selectList("findByDuibaQuizzId", paramMap);
	}

	@Override
	public void delete(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		delete("delete", paramMap);
	}

	@Override
	public void insert(DuibaQuizzAppSpecifyEntity duibaQuizzAppSpecify) {
		insert("insert", duibaQuizzAppSpecify);
	}

	@Override
	public DuibaQuizzAppSpecifyEntity findByDuibaQuizzAndApp(Long duibaQuizzId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaQuizzId", duibaQuizzId);
		paramMap.put("appId", appId);
		return selectOne("findByDuibaQuizzAndApp", paramMap);
	}

	public List<DuibaQuizzAppSpecifyEntity> findByDuibaQuizzsAndApp(List<Long> duibaQuizzIds, Long appId){
		if(duibaQuizzIds == null || duibaQuizzIds.isEmpty()){
			return Collections.emptyList();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaQuizzIds", duibaQuizzIds);
		paramMap.put("appId", appId);
		return selectList("findByDuibaQuizzsAndApp", paramMap);
	}

	@Override
	public DuibaQuizzAppSpecifyEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}
	
	public DuibaQuizzAppSpecifyEntity findByQuizzIdAndAppId(Long quizzId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("quizzId", quizzId);
		paramMap.put("appId", appId);
		return selectOne("findByQuizzIdAndAppId",paramMap);
	}


	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.QUIZZ;
	}
}
