package cn.com.duiba.activity.center.biz.dao.seconds_kill_app.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.seconds_kill_app.SeckillAppOrderDao;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.SeckillOrdersEntity;
import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;

@Repository
public class SeckillAppOrderDaoImpl extends ActivityBaseDao implements SeckillAppOrderDao{

	@Override
	public List<SeckillOrdersEntity> selectByLimit(Map<String, Object> queryMap) {
		Long appId= (Long)queryMap.get("appId");
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.putAll(queryMap);
		return selectList(("selectByLimit"), paramMap);
	}

	
	@Override
	public Long selectTotalCount(Map<String, Object> queryMap) {
		Long appId= (Long)queryMap.get("appId");
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.putAll(queryMap);
		return selectOne(("selectTotalCount"), paramMap);
	}

	@Override
	public List<DeveloperActivityStatisticsEntity> selectCountFailByOperatingActivityIds(
			List<Long> ids, Long appId) {
		Map<String, Object> queryMap = getTbSuffixParamsMap(appId);
		queryMap.put("ids", ids);
		queryMap.put("appId", appId);
		return selectList("selectcountFailByOperatingActivityIds",queryMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.SECKILL_APP;
	}

}
