package cn.com.duiba.activity.center.biz.dao.singlelottery;

import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.singlelottery.SingleLotteryOrderEntity;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/24.
 */
public interface SingleLotteryOrderDao {

    //from SingleLotteryOrderSimpleDAO
    /**
     * 根据ID查询单品抽奖订单
     */
    SingleLotteryOrderEntity find(Long id);

    /**
     * 统计奖项用户中奖次数
     */
    Integer countByConsumerIdAndOptionType(Long activityId, Long consumerId, Integer optionType);

    /**
     * 根据ID集合查询订单
     */
    List<SingleLotteryOrderEntity> findAllByIds(List<Long> ids);

    /**
     * 查询当前用户在当前活动当前APP的抽奖次数
     */
    Integer findLotteryCountByComsumer(Long activityId, Long appId, Long consumerId);

    /**
     * 查询当天当前用户在当前活动当前APP的抽奖次数
     */
    Integer findCountByComsumerTime(Long activityId, Long appId, Long consumerId, Date statTime, Date endTime);

    /**
     * 查询前台显示5条中奖名单
     */
    List<SingleLotteryOrderEntity> findFrontLotteryList(Long activityId, Long appId);

    /**
     * 根据上游订单号查单
     */
    SingleLotteryOrderEntity findByAppAndDeveloperBizId(Long appId, String bizId);

    /**
     * 根据订单ID查询订单信息
     */
    List<SingleLotteryOrderEntity> findByIds(List<Long> ids);
    /**
     * 根据主订单ID集合查询单品订单
     */
    List<SingleLotteryOrderEntity> findByInOrderIds(List<Long> ids);

    /**
     * 查询创建时间小于 PARAM的订单
     * 扫描24小时没有领奖的订单，查询较慢，待优化
     */
    List<SingleLotteryOrderEntity> findAllByLtGmtCreateAndExchangeStatus();

    /**
     * 获取失败订单数
     */
    List<DeveloperActivityStatisticsEntity> findFailCountByOperatingActivityIds(List<Long> operatingActivityIds);

    /**
     * 单品抽奖订单分页
     */
    List<SingleLotteryOrderEntity> findByLimit(Map<String, Object> paramMap);

    /**
     * 单品抽奖订单分页条数
     */
    Long findByCount(Map<String, Object> paramMap);

    /**
     * 根据奖项类型查询中奖人数
     */
    Integer countWintimesByOptionType(List<Long> operatingActivityIds, Date statTime, Date endTime, Integer optionType);

    /**
     * 根据开发者单品活动ID列表得到活动ID对中大奖人数的Map
     */
    List<SingleLotteryOrderEntity> getWinningListByOperatingActivityIds(Collection<Long> operatingActivityIds);

    // from SingleLotteryOrderStatusChangeDAO

    /**
     * 修改订单领奖状态为失败
     */
    int updateExchangeStatusToFail(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 修改订单领奖状态为过期失效
     */
    int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 修改订单状态成功，领奖状态待领奖
     */
    int updateStatusToSuccess(long id);

    /**
     * 修改订单状态失败
     */
    int updateStatusToFail(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 订单抽奖失败，修改为未中奖
     */
    int updatePrizeTypeToThanks(long id);

    /**
     * 处理领奖
     */
    Integer doTakePrize(Long id);

    /**
     * 领奖创建主订单失败回滚领奖
     */
    Integer rollbackTakePrize(Long id);

    /**
     * 修改订单抽奖结果
     */
    Integer updateLotteryResult(Long id, Long appItemId, Long itemId, String prizeName, String prizeType, String prizeDegree, Integer prizeFacePrice, Integer optionType, Long couponId);

    // SingleLotteryOrderTextChangeDAO

    /**
     * 修改开发者订单号
     */
    int updateDeveloperBizId(long id, String bizId);

    /**
     * 修改主订单ID
     */
    int updateMainOrderId(long id, Long orderId);

    /**
     * 新增单品抽奖订单
     */
    void insert(SingleLotteryOrderEntity singleLotteryOrderDO);
}
