package cn.com.duiba.activity.center.biz.dao.singlelottery.impl;

import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryOrderDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.singlelottery.SingleLotteryOrderDao;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.singlelottery.SingleLotteryOrderEntity;
import org.springframework.stereotype.Repository;

import java.util.*;

import static cn.com.duiba.activity.center.biz.support.TableHelper.subString;

/**
 * Created by yansen on 16/6/24.
 */
@Repository
public class SingleLotteryOrderDaoImpl extends ActivityBaseDao implements SingleLotteryOrderDao {

    //from SingleLotteryOrderSimpleDAO

    /**
     * 根据ID查询单品抽奖订单
     */
    @Override
    public SingleLotteryOrderEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    /**
     * 统计奖项用户中奖次数
     */
    @Override
    public Integer countByConsumerIdAndOptionType(Long activityId, Long consumerId, Integer optionType) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("operatingActivityId", activityId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("optionType", optionType);
        return selectOne("countByConsumerIdAndOptionType", paramMap);
    }

    /**
     * 根据ID集合查询订单
     */
    @Override
    public List<SingleLotteryOrderEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("findAllByIds", paramMap);
    }

    /**
     * 查询当前用户在当前活动当前APP的抽奖次数
     */
    @Override
    public Integer findLotteryCountByComsumer(Long activityId, Long appId, Long consumerId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("appId", appId);
        paramMap.put("consumerId", consumerId);
        return selectOne("findLotteryCountByComsumer", paramMap);
    }

    /**
     * 查询当天当前用户在当前活动当前APP的抽奖次数
     */
    @Override
    public Integer findCountByComsumerTime(Long activityId, Long appId, Long consumerId, Date statTime, Date endTime) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("appId", appId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("statTime", statTime);
        paramMap.put("endTime", endTime);
        return selectOne("findCountByComsumerTime", paramMap);
    }

    /**
     * 查询前台显示5条中奖名单
     */
    @Override
    public List<SingleLotteryOrderEntity> findFrontLotteryList(Long activityId, Long appId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("appId", appId);
        return selectList("findFrontLotteryList", paramMap);
    }

    /**
     * 根据上游订单号查单
     */
    @Override
    public SingleLotteryOrderEntity findByAppAndDeveloperBizId(Long appId, String bizId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("bizId", bizId);
        return selectOne("findByAppAndDeveloperBizId", paramMap);
    }

    /**
     * 根据订单ID查询订单信息
     */
    @Override
    public List<SingleLotteryOrderEntity> findByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("findByIds", paramMap);
    }

    /**
     * 根据主订单ID集合查询单品订单
     */
    @Override
    public List<SingleLotteryOrderEntity> findByInOrderIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("findByInOrderIds", paramMap);
    }

    /**
     * 查询创建时间小于 PARAM的订单
     * 扫描24小时没有领奖的订单，查询较慢，待优化
     */
    @Override
    public List<SingleLotteryOrderEntity> findAllByLtGmtCreateAndExchangeStatus() {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.DATE, -1);
        Date endTime = cal.getTime();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(endTime);
        cal1.add(Calendar.DATE, -1);
        Date startTime = cal1.getTime();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        paramMap.put("exchangeStatus", SingleLotteryOrderDto.ExchangeStatusWait);
        return selectList("findAllByLtGmtCreateAndExchangeStatus", paramMap);
    }

    /**
     * 获取失败订单数
     */
    @Override
    public List<DeveloperActivityStatisticsEntity> findFailCountByOperatingActivityIds(List<Long> operatingActivityIds) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("operatingActivityIds", operatingActivityIds);
        return selectList("findFailCountByOperatingActivityIds", paramMap);
    }

    /**
     * 单品抽奖订单分页
     */
    @Override
    public List<SingleLotteryOrderEntity> findByLimit(Map<String, Object> paramMap) {
        return selectList("findByLimit", paramMap);
    }

    /**
     * 单品抽奖订单分页条数
     */
    @Override
    public Long findByCount(Map<String, Object> paramMap) {
        return selectOne("findByCount", paramMap);
    }

    /**
     * 根据奖项类型查询中奖人数
     */
    @Override
    public Integer countWintimesByOptionType(List<Long> operatingActivityIds, Date statTime, Date endTime, Integer optionType) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("operatingActivityIds", operatingActivityIds);
        paramMap.put("statTime", statTime);
        paramMap.put("endTime", endTime);
        paramMap.put("optionType", optionType);
        return selectOne("countWintimesByOptionType", paramMap);
    }

    /**
     * 根据开发者单品活动ID列表得到活动ID对中大奖人数的Map
     */
    @Override
    public List<SingleLotteryOrderEntity> getWinningListByOperatingActivityIds(Collection<Long> operatingActivityIds) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("operatingActivityIds", operatingActivityIds);
        return selectList("getWinningListByOperatingActivityIds", paramMap);
    }

    // from SingleLotteryOrderStatusChangeDAO

    /**
     * 修改订单领奖状态为失败
     */
    @Override
    public int updateExchangeStatusToFail(long id, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", SingleLotteryOrderDto.ExchangeStatusFail);
        paramMap.put("error4admin", subString(error4admin,200));
        paramMap.put("error4developer", subString(error4developer,200));
        paramMap.put("error4consumer", subString(error4consumer,200));
        return update("updateExchangeStatusToFail", paramMap);
    }

    /**
     * 修改订单领奖状态为过期失效
     */
    @Override
    public int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", SingleLotteryOrderDto.ExchangeStatusOverdue);
        paramMap.put("error4admin", subString(error4admin,200));
        paramMap.put("error4developer", subString(error4developer,200));
        paramMap.put("error4consumer", subString(error4consumer,200));
        return update("updateExchangeStatusToOverdue", paramMap);
    }

    /**
     * 修改订单状态成功，领奖状态待领奖
     */
    @Override
    public int updateStatusToSuccess(long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", SingleLotteryOrderDto.StatusSuccess);
        paramMap.put("exchangeStatus", SingleLotteryOrderDto.ExchangeStatusWait);
        return update("updateStatusToSuccess", paramMap);
    }

    /**
     * 修改订单状态失败
     */
    @Override
    public int updateStatusToFail(long id, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", SingleLotteryOrderDto.StatusFail);
        paramMap.put("error4admin", subString(error4admin,200));
        paramMap.put("error4developer", subString(error4developer,200));
        paramMap.put("error4consumer", subString(error4consumer,200));
        return update("updateStatusToFail", paramMap);
    }

    /**
     * 订单抽奖失败，修改为未中奖
     */
    @Override
    public int updatePrizeTypeToThanks(long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", SingleLotteryOrderDto.StatusSuccess);
        paramMap.put("prizeName", "谢谢参与");
        paramMap.put("exchangeStatus", SingleLotteryOrderDto.ExchangeStatusSuccess);
        paramMap.put("optionType", SingleLotteryOrderDto.OptionTypeNo);
        return update("updatePrizeTypeToThanks", paramMap);
    }

    /**
     * 处理领奖
     */
    @Override
    public Integer doTakePrize(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("doTakePrize", paramMap);
    }

    /**
     * 领奖创建主订单失败回滚领奖
     */
    @Override
    public Integer rollbackTakePrize(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("rollbackTakePrize", paramMap);
    }

    /**
     * 修改订单抽奖结果
     */
    @Override
    public Integer updateLotteryResult(Long id, Long appItemId, Long itemId, String prizeName, String prizeType, String prizeDegree, Integer prizeFacePrice, Integer optionType, Long couponId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("appItemId", appItemId);
        paramMap.put("itemId", itemId);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeDegree", prizeDegree);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("optionType", optionType);
        paramMap.put("couponId", couponId);
        paramMap.put("status", SingleLotteryOrderDto.StatusSuccess);
        paramMap.put("exchangeStatus", SingleLotteryOrderDto.ExchangeStatusWait);
        return update("updateLotteryResult", paramMap);
    }

    // SingleLotteryOrderTextChangeDAO

    /**
     * 修改开发者订单号
     */
    @Override
    public int updateDeveloperBizId(long id, String bizId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("bizId", bizId);
        return update("updateDeveloperBizId", paramMap);
    }

    /**
     * 修改主订单ID
     */
    @Override
    public int updateMainOrderId(long id, Long orderId){
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("orderId", orderId);
        return update("updateMainOrderId", paramMap);
    }

    /**
     * 新增单品抽奖订单
     */
    @Override
    public void insert(SingleLotteryOrderEntity singleLotteryOrderDO) {
        insert("insert", singleLotteryOrderDO);
    }



    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
