package cn.com.duiba.activity.center.biz.plugin.event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent.ConsumeCreditsFailListener;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent.ConsumeCreditsSuccessListener;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent.ActivityOrderPluginContext;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventListener;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.pool.ThreadPoolDuibaService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;

import java.util.ArrayList;
import java.util.List;

public class DuibaEventsDispatcher {

	private static Logger log = LoggerFactory.getLogger(DuibaEventsDispatcher.class);

	private static DuibaEventsDispatcher dispatcher = new DuibaEventsDispatcher();

	public static DuibaEventsDispatcher get() {
		return dispatcher;
	}

	public void dispatchEvent(final DuibaEvent<?> e) {
		if (e instanceof ActivityOrdersEvent) {
		    processActivityOrdersEvent((ActivityOrdersEvent) e);
		}
	}


	private void processActivityOrdersEvent(final ActivityOrdersEvent event) {
		final List<ActivityOrdersEventListener> listeners = DuibaEventsRegister.get().activityOrderListener;
		if (!listeners.isEmpty()) {
		    ThreadPoolDuibaService.get().submit(new Runnable() {
                public void run() {
        			for (ActivityOrdersEventListener l : new ArrayList<ActivityOrdersEventListener>(listeners)) {
        				try {
        					if (event.getType() == ActivityOrdersEventType.OnOrderCreate) {
        						l.onOrderCreate(event.getData());
        					} else if (event.getType() == ActivityOrdersEventType.OnOrderSuccess) {
        						l.onOrderSuccess(event.getData());
        					} else if (event.getType() == ActivityOrdersEventType.OnOrderFail) {
        						l.onOrderFail(event.getData());
        					}
        				} catch (Exception e) {
        					log.error("processActivityOrderEvent", e);
        				}
        			}
                }
            }, ThreadPoolDuibaService.PriorityNormal);
		}
	}
	
	public void triggerAfterActivityOrderCreate(ActivityOrderDto order) {
        for(ActivityOrderSyncEvent p:new ArrayList<ActivityOrderSyncEvent>(DuibaEventsRegister.get().activityOrderPlugins)){
            try {
                p.afterOrderCreate(order);
            } catch (Exception e) {
                log.error(p.getClass().getName()+" process error",e);
            }
        }
    }
	
	public void triggerBeforeActivityOrderComplete(ActivityOrderDto order,ActivityPrizeOptionDto option,ActivityOrderPluginContext context) throws Exception{
        for(ActivityOrderSyncEvent p:new ArrayList<ActivityOrderSyncEvent>(DuibaEventsRegister.get().activityOrderPlugins)){
            p.beforeStockComplete(order, option, context);
        }
    }
	
	public void triggerOnActivityOrderCompleteException(ActivityOrderDto order,ActivityPrizeOptionDto option,Exception exception,ActivityOrderPluginContext context){
        for(ActivityOrderSyncEvent p:new ArrayList<ActivityOrderSyncEvent>(DuibaEventsRegister.get().activityOrderPlugins)){
            try{
                p.beforeStockCompleteException(order, option, exception, context);
            } catch(Exception e){
                log.error(p.getClass().getName()+" process error",e);
            }
        }
    }
	
	
	public void dispatchConsumeCreditsFailEvent(final ConsumeCreditsFailEvent event) {
        if (event.getException() != null) {
            ThreadPoolDuibaService.get().submit(new Runnable() {
                @Override
                public void run() {
                    List<ConsumeCreditsFailListener> listeners = DuibaEventsRegister.get().consumeCreditsFailListeners;
                    if (event.getActivityOrder() != null) {
                        for (ConsumeCreditsFailListener l : listeners) {
                            try {
                                l.onConsumeActivityOrderFail(event.getActivityOrder(), event.getException());
                            } catch (Exception e) {
                                log.error("dispatchConsumeCreditsFailEvent", e);
                            }
                        }
                    }
                }
            }, ThreadPoolDuibaService.PriorityLow);
        }
    }
	
	public void dispatchConsumeCreditsSuccessEvent(final ConsumerCreditsSuccessEvent event) {
        ThreadPoolDuibaService.get().submit(new Runnable() {
            @Override
            public void run() {
                List<ConsumeCreditsSuccessListener> listeners = DuibaEventsRegister.get().consumeCreditsSuccessListeners;
                if (event.getActivityOrder() != null) {
                    for (ConsumeCreditsSuccessListener l : listeners) {
                        try {
                            l.onConsumeOrderSuccess(event.getActivityOrder());
                        } catch (Exception e) {
                            log.error("dispatchConsumeCreditsSuccessEvent", e);
                        }
                    }
                }
            }
        }, ThreadPoolDuibaService.PriorityLow);
    }

}
