package cn.com.duiba.activity.center.biz.plugin.event.credits;

import cn.com.duiba.order.center.api.dto.ActivityOrderDto;

/**
 * 扣积分失败事件
 * @author xuhengfei
 *
 */
public class ConsumeCreditsFailEvent {
	
	private ActivityOrderDto activityOrder;
	
	private Exception exception;
	
	public ConsumeCreditsFailEvent(ActivityOrderDto order,Exception e){
		this.activityOrder=order;
		this.exception=e;
	}
	
	public interface ConsumeCreditsFailListener{
	    
		/**
		 * 新活动扣积分失败
		 * @param order
		 * @param e
		 */
		void onConsumeActivityOrderFail(ActivityOrderDto order, Exception e);
		
	}

    public ActivityOrderDto getActivityOrder() {
        return activityOrder;
    }

    
    public void setActivityOrder(ActivityOrderDto activityOrder) {
        this.activityOrder = activityOrder;
    }

    public Exception getException() {
		return exception;
	}

    public void setException(Exception exception) {
        this.exception = exception;
    }
    
}
