/**
 * Project Name:activity-center-biz
 * File Name:ActivityCouponStockPluginImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin.stock
 * Date:2016年7月29日下午3:37:44
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.plugin.stock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteCouponFlowService;
import cn.com.duiba.service.item.remoteservice.RemoteCouponService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;

/**
 * ClassName:ActivityCouponStockPluginImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午3:37:44 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class ActivityCouponStockPluginImpl implements InitializingBean{
    
    private static Logger log = LoggerFactory.getLogger(ActivityCouponStockPluginImpl.class);
    @Autowired
    private RemoteItemKeyService remoteItemKeySerivce;
    @Autowired
    private RemoteCouponService remoteCouponService;
    @Autowired
    private RemoteCouponFlowService remoteCouponFlowService;
    
    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){

        private static final String ACTIVITY_COUPON = "__activity_coupon_stock_consume";
        
        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
            
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                        ActivityOrderPluginContext context) throws Exception {
            if(option.getPrizeType().equals(ItemDO.TypeCoupon)){
                try{
                    ItemKey key = remoteItemKeySerivce.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId()); 
                    CouponDO coupon = remoteCouponFlowService.getOneCoupon(key);
                    if(null == coupon){
                        throw new Exception("优惠券减库存失败");
                    }
                    context.setAttribute(ACTIVITY_COUPON,true);
                    context.setAttribute("couponId", coupon.getId());
                }catch(Exception e){
                    log.error("className: "+this.getClass().getName()+" method: getOneCoupon,新活动优惠券减库存失败",e);
                    throw e;
                }
            }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                                 Exception exception, ActivityOrderPluginContext context) {
            if(option.getPrizeType().equals(ItemDO.TypeCoupon)){
                try{
                    Boolean hasadd=(Boolean) context.getAttribute(ACTIVITY_COUPON);
                    Object couponId = context.getAttribute("couponId");
                    if(hasadd!=null && hasadd && couponId != null){
                        remoteCouponFlowService.returnOneCoupon((Long)couponId);
                    }
                    context.remove(ACTIVITY_COUPON);
                }catch(Exception e){
                    log.error("className: "+this.getClass().getName()+" method: getOneCoupon,新活动优惠券减库存失败",e);
                }
            }
        }
        
    };
    
    @Override
    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(orderPlugin);
    }

}

