/**
 * Project Name:activity-center-biz
 * File Name:ActivityDirectItemStockPluginImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin.stock
 * Date:2016年7月29日下午4:21:53
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.plugin.stock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.dataobject.ItemAppSpecifyDO;
import cn.com.duiba.service.item.domain.dataobject.ItemStockSpecifyConsumeDO;
import cn.com.duiba.service.item.remoteservice.RemoteItemAppSpecifyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemStockConsumeService;

/**
 * ClassName:ActivityDirectItemStockPluginImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午4:21:53 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class ActivityDirectItemStockPluginImpl implements InitializingBean{
    
    private static Logger log = LoggerFactory.getLogger(ActivityDirectItemStockPluginImpl.class);
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemoteItemAppSpecifyService remoteItemAppSpecifyService;
    @Autowired
    private RemoteItemStockConsumeService remoteItemStockConsumeService;

    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){
        
        private static final String ACTIVITY_REDIRECT_CONSUME_STOCK = "__activity_redirect_stock_consume";

        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
            
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                        ActivityOrderPluginContext context) throws Exception {
            if(option.getPrizeType().equals(ItemDO.TypeObject)
                    || option.getPrizeType().equals(ItemDO.TypeCoupon)){
                     try{
                         ItemKey key = remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                         
                         if(key.getItem() != null && key.getItem().isOpTypeItem(ItemDO.OpTypeSpecify)){
                             
                             ItemAppSpecifyDO itemAppSpecifyDO = remoteItemAppSpecifyService.findByItemIdAndAppId(key.getItem().getId(), key.getApp().getId());
                             
                             if(null != itemAppSpecifyDO){
                                 //要增加活动类型
                                 remoteItemStockConsumeService.consumeRedirectStock(key, order.getOrderNum(), ItemStockSpecifyConsumeDO.BIZ_SOURCE_ACTIVITY_SPECIFY);
                                 
                                 context.setAttribute(ACTIVITY_REDIRECT_CONSUME_STOCK, true);
                             }
                         }
                     }catch(Exception e){
                         log.error("className: "+this.getClass().getName()+" method: consumeStock,减定向库存失败",e);
                         throw e;
                     }
                 }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                                 Exception exception, ActivityOrderPluginContext context) {
            if(option.getPrizeType().equals(ItemDO.TypeObject)
                    || option.getPrizeType().equals(ItemDO.TypeCoupon)){
                     try{
                         ItemKey key = remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                         
                         if(key.getItem() != null && key.getItem().isOpTypeItem(ItemDO.OpTypeSpecify)){
                             
                             ItemAppSpecifyDO itemAppSpecifyDO = remoteItemAppSpecifyService.findByItemIdAndAppId(key.getItem().getId(), key.getApp().getId());
                             
                             if(null != itemAppSpecifyDO){
                                 Boolean hasadd=(Boolean) context.getAttribute(ACTIVITY_REDIRECT_CONSUME_STOCK);
                                 
                                 if(hasadd != null && hasadd){
                                     //返还定向库存
                                     remoteItemStockConsumeService.paybackRedirectStock(order.getOrderNum(), ItemStockSpecifyConsumeDO.BIZ_SOURCE_ACTIVITY_SPECIFY);
                                 }
                                 context.remove(ACTIVITY_REDIRECT_CONSUME_STOCK);
                             }
                         }
                     }catch(Exception e){
                         log.error("className: "+this.getClass().getName()+" method: consumeStock,返定向库存失败",e);
                     }
                 }
        }
        
    };
    
    @Override
    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(orderPlugin);
    }

}

