/**
 * Project Name:activity-center-biz
 * File Name:ActivityItemPreStockPluginImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin.stock
 * Date:2016年7月29日下午4:13:07
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.plugin.stock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.dataobject.PreStockPointDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;

/**
 * ClassName:ActivityItemPreStockPluginImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午4:13:07 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class ActivityItemPreStockPluginImpl implements InitializingBean{
    
    private static Logger log = LoggerFactory.getLogger(ActivityItemPreStockPluginImpl.class);
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemotePreStockService remotePreStockService;
    
    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){
        
        private static final String ACTIVITY_PRE_STOCK = "__activity_pre_stock_consume";

        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
            
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                        ActivityOrderPluginContext context) throws Exception {
            if(option.getPrizeType().equals(ItemDO.TypeObject)
                    || option.getPrizeType().equals(ItemDO.TypeCoupon)){
                     try{
                         ItemKey key = remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                         
                         if(key.getItem() != null && key.getItem().isOpTypeItem(ItemDO.OpTypePreStockSwith)){
                             PreStockPointDO point = remotePreStockService.getPointStock(key.getItem(),key.getApp());
                             
                             if(null != point){
                                 remotePreStockService.consumeStock("activity-" + order.getOrderNum(), key.getApp().getId(), point.getId());
                                 context.setAttribute(ACTIVITY_PRE_STOCK, true);
                             }
                         }
                     }catch(Exception e){
                         log.error("className: "+this.getClass().getName()+" method: consumeStock,减预分配库存失败",e);
                         throw e;
                     }
                 }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                                 Exception exception, ActivityOrderPluginContext context) {
            if(option.getPrizeType().equals(ItemDO.TypeObject)
                    || option.getPrizeType().equals(ItemDO.TypeCoupon)){
                     try{
                         ItemKey key = remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                         
                         if(key.getItem() != null && key.getItem().isOpTypeItem(ItemDO.OpTypePreStockSwith)){
                             Boolean hasadd=(Boolean) context.getAttribute(ACTIVITY_PRE_STOCK);
                             
                             if(hasadd!=null && hasadd){
                                 remotePreStockService.paybackStock("activity-" + order.getOrderNum());
                             }
                             context.remove(ACTIVITY_PRE_STOCK);
                         }
                     }catch(Exception e){
                         log.error("className: "+this.getClass().getName()+" method: consumeStock,返预分配库存失败",e);
                     }
                 }
        }
        
    };

    @Override
    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(orderPlugin);
    }

}

