/**
 * Project Name:activity-center-biz File Name:RemoteActivityCategoryBackendServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl Date:2016年6月7日上午8:55:59 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.other.ActivityCategorySpecifyDto;
import cn.com.duiba.activity.center.api.remoteservice.RemoteActivityCategoryBackendService;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.entity.chaos.ActivityCategorySpecifyEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import cn.com.duiba.activity.center.biz.service.chaos.ActivityCategorySpecifyService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemoteActivityCategoryBackendServiceImpl <br/>
 * Date: 2016年6月7日 上午8:55:59 <br/>
 * 
 * @author xuhengfei
 * @version
 * @since JDK 1.6
 * @see
 */
@Service("remoteActivityCategoryBackendService")
public class RemoteActivityCategoryBackendServiceImpl implements RemoteActivityCategoryBackendService {

    private static final Logger             log = LoggerFactory.getLogger(RemoteActivityCategoryBackendServiceImpl.class);
    @Autowired
    private ActivityCategoryService         activityCategoryService;
    @Autowired
    private ActivityCategoryRelationService activityCategoryRelationService;

    @Autowired
    private ActivityCategorySpecifyService  activityCategorySpecifyService;

    @Override
    public DubboResult<Long> createCategory(String name, String content) {
        try {
            Long id = activityCategoryService.createCategory(name, content);
            return DubboResult.successResult(id);
        } catch (Exception e) {
            log.error("createCategory name=" + name, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> editCategoryContent(long id, String name, String content) {
        try {
            Boolean ret = activityCategoryService.editCategoryContent(id, name, content);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("editCategoryContent id=" + id + ",content=" + content, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> enableCategory(long id) {
        try {
            Boolean ret = activityCategoryService.enableCategory(id);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("enableCategory id=" + id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> disableCategory(long id) {
        try {
            Boolean ret = activityCategoryService.disableCategory(id);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("disableCategory id=" + id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ActivityCategoryDto>> findAll() {
        try {
            List<ActivityCategoryDto> ret = new ArrayList<>();
            List<ActivityCategoryEntity> list = activityCategoryService.findAll();
            for (ActivityCategoryEntity e : list) {
                ActivityCategoryDto dto = new ActivityCategoryDto();
                dto.setId(e.getId());
                dto.setName(e.getName());
                dto.setEnable(e.getEnable());
                dto.setContent(e.getContent());
                dto.setSpecify(e.getSpecify());
                ret.add(dto);
            }
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("findAll", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteCategory(long id) {
        try {
            Boolean ret = activityCategoryService.deleteCategory(id);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("deleteCategory id=" + id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ActivityCategoryDto> findDefaultCategory() {
        try {
            ActivityCategoryEntity e = activityCategoryService.findDefaultCategory();
            if (e == null) {
                return DubboResult.failResult("没有默认分类");
            } else {
                ActivityCategoryDto dto = new ActivityCategoryDto();
                dto.setId(e.getId());
                dto.setName(e.getName());
                dto.setEnable(e.getEnable());
                dto.setContent(e.getContent());
                dto.setSpecify(e.getSpecify());
                return DubboResult.successResult(dto);
            }
        } catch (Exception e) {
            log.error("findDefaultCategory", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategory(long appId, long categoryId) {

        try {
            // find all by appId,categoryId
            List<ActivityCategoryRelationEntity> acrs = this.activityCategoryRelationService.findByAppCategory(appId,
                                                                                                               categoryId);
            List<CategoryActivityDto> dtos = new ArrayList<CategoryActivityDto>();

            if (acrs != null && acrs.size() > 0) {
                for (ActivityCategoryRelationEntity acr : acrs) {

                    CategoryActivityDto dto = new CategoryActivityDto();
                    dto.setId(acr.getId());
                    dto.setOperatingId(acr.getOperatingActivityId());
                    dto.setPayload(acr.getPayload());
                    dto.setAppId(appId);
                    dto.setCategoryId(categoryId);

                    dtos.add(dto);
                }
            }
            return DubboResult.successResult(dtos);
        } catch (Exception e) {
            log.error("findAllActivitiesByAppCategory error,appId=" + appId + ",categoryId=" + categoryId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> sortActivitiesByAppCategory(long appId, long categoryId,
                                                            List<CategoryActivityDto> activities) {
        try {
            if (this.activityCategoryRelationService.sortActivities(activities)) {
                return DubboResult.successResult(true);
            } else return DubboResult.failResult("更新失败");
        } catch (Exception e) {
            log.error("sortActivitiesByAppCategory error,appId=" + appId + ",categoryId=" + categoryId
                      + ",activities is list", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> saveActivityCategoryRelation(CategoryActivityDto dto) {
        Long appId = dto.getAppId();
        Long categoryId = dto.getCategoryId();
        Long oaId = dto.getOperatingId();
        Integer payload = dto.getPayload();

        if (appId == null) {
            return DubboResult.failResult("appId 不得为空");
        }
        if (categoryId == null) {
            return DubboResult.failResult("categoryId 不得为空");
        }
        if (oaId == null) {
            return DubboResult.failResult("operatingActivityId 不得为空");
        }
        if (payload == null) {
            return DubboResult.failResult("payload 不得为空");
        }

        ActivityCategoryRelationEntity entity = new ActivityCategoryRelationEntity();
        try {
            entity.setAppId(appId);

            entity.setCategoryId(categoryId);
            entity.setOperatingActivityId(oaId);
            entity.setPayload(payload);
            if (this.activityCategoryRelationService.save(entity)) {
                return DubboResult.successResult(true);
            } else {
                return DubboResult.failResult("saveActivityCategoryRelation error,appId=" + appId + ",categoryId="
                                              + categoryId + ",operatingActivityId=" + oaId + ",payload" + payload);
            }
        } catch (Exception e) {
            log.error("saveActivityCategoryRelation error,appId=" + appId + ",categoryId=" + categoryId
                      + ",operatingActivityId=" + oaId + ",payload" + payload, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> removeActivityCategoryRelation(Long operatingActivityId) {

        if (operatingActivityId == null) {
            return DubboResult.failResult("operatingActivityId 不得为空");
        }

        try {
            if (this.activityCategoryRelationService.remove(operatingActivityId)) {
                return DubboResult.successResult(true);
            } else {
                return DubboResult.failResult("删除失败");
            }
        } catch (Exception e) {
            log.error("error:", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<CategoryActivityDto> findActivityCategoryRelation(Long operatingActivityId) {
        CategoryActivityDto dto;
        try {
            ActivityCategoryRelationEntity rs = this.activityCategoryRelationService.findByOperatingActivityId(operatingActivityId);
            if (rs == null) {
                dto = null;
            } else {
                dto = new CategoryActivityDto();
                dto.setId(rs.getId());
                dto.setAppId(rs.getAppId());
                dto.setCategoryId(rs.getCategoryId());
                dto.setOperatingId(rs.getOperatingActivityId());
                dto.setPayload(rs.getPayload());
            }
            return DubboResult.successResult(dto);
        } catch (Exception e) {
            log.error("findActivityCategoryRelation error,operatingActivityId=" + operatingActivityId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateActivityCategoryRelation(Long categoryId,
                                                               List<OperatingActivityDto> operatingActivityList) {
        if (CollectionUtils.isEmpty(operatingActivityList)) {
            log.warn("operatingActivityIdList is null, categoryId=" + categoryId);
            return DubboResult.successResult(true);
        }
        try {
            boolean rs = activityCategoryRelationService.updateActivityCategoryRelation(categoryId,
                                                                                        operatingActivityList);
            if (rs) {
                return DubboResult.successResult(true);
            } else {
                return DubboResult.failResult("更新活动归类失败，categoryId=" + categoryId);
            }
        } catch (Exception e) {
            log.error("更新活动归类失败，categoryId=" + categoryId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ActivityCategorySpecifyDto>> findSpecifyAll(Long activityCategoryId, Integer pageIndex,
                                                                        Integer pageSize) {
        try {
            List<ActivityCategorySpecifyDto> list = new ArrayList<ActivityCategorySpecifyDto>();
            List<ActivityCategorySpecifyEntity> ret = activityCategorySpecifyService.findAll(activityCategoryId,
                                                                                             pageIndex, pageSize);
            ObjectUtil.convertList(ret, list, ActivityCategorySpecifyDto.class);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            log.error("findSpecifyAll", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> findSpecifyAllCount(Long activityCategoryId, Integer pageIndex, Integer pageSize) {
        try {
            return DubboResult.successResult(activityCategorySpecifyService.findSpecifyAllCount(activityCategoryId,
                                                                                                pageIndex, pageSize));
        } catch (Exception e) {
            log.error("findSpecifyAllCount", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> specifySave(ActivityCategorySpecifyDto activityCategorySpecifyDto) {
        try {
            ActivityCategorySpecifyEntity ac = new ActivityCategorySpecifyEntity();
            ObjectUtil.convert(activityCategorySpecifyDto, ac);
            Boolean ret = activityCategorySpecifyService.specifySave(ac);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("specifySave", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> specifyDelete(Long id) {
        try {
            Boolean ret = activityCategorySpecifyService.specifyDelete(id);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("specifyDelete", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ActivityCategorySpecifyDto>> findByAppSpecifys(long appId) {
        try {
            List<ActivityCategorySpecifyDto> list = new ArrayList<ActivityCategorySpecifyDto>();
            List<ActivityCategorySpecifyEntity> ret = activityCategorySpecifyService.findByAppSpecifys(appId);
            ObjectUtil.convertList(ret, list, ActivityCategorySpecifyDto.class);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            log.error("findByAppSpecifys", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ActivityCategoryDto>> findCategoryByAppId(Long appId) {
        try {
            List<ActivityCategoryEntity> list = activityCategoryService.findCategoryByAppId(appId);
            return DubboResult.successResult(BeanUtils.copyList(list, ActivityCategoryDto.class));
        } catch (Exception e) {
            log.error("invoke findCategoryByAppId failed, appId=" + appId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
