package cn.com.duiba.activity.center.biz.remoteservice.impl.activity_brick;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.remoteservice.activity_brick.RemotePopupActivityBrickBackendService;
import cn.com.duiba.activity.center.biz.service.activity_brick.PopupActivityBrickService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemotePopupActivityBrickBackendServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月12日 下午3:04:55 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class RemotePopupActivityBrickBackendServiceImpl implements
		RemotePopupActivityBrickBackendService {

	@Resource
	private PopupActivityBrickService popupActivityBrickService;
	
	@Override
	public DubboResult<PopupActivityBrickDto> insert(PopupActivityBrickDto brick) {
		return DubboResult.successResult(popupActivityBrickService.insert(brick));
	}

	@Override
	public DubboResult<Integer> update(PopupActivityBrickDto brick) {
		return DubboResult.successResult(popupActivityBrickService.update(brick));
	}

	@Override
	public DubboResult<PopupActivityBrickDto> findById(Long id) {
		return DubboResult.successResult(popupActivityBrickService.findById(id));
	}

	@Override
	public DubboResult<Integer> deleteById(Long id) {
		return DubboResult.successResult(popupActivityBrickService.deleteById(id));
	}

	@Override
	public DubboResult<Integer> showBrick(Long id) {
		return DubboResult.successResult(popupActivityBrickService.showBrick(id));
	}

	@Override
	public DubboResult<Integer> hiddenBrick(Long id) {
		return DubboResult.successResult(popupActivityBrickService.hiddenBrick(id));
	}

	@Override
	public DubboResult<List<PopupActivityBrickDto>> findPage(Integer offset, Integer max) {
		Map<String, Object> paramMap =new HashMap<String, Object>();
		if (offset != null){
			paramMap.put("offset", offset);
		}
		if (max != null){
			paramMap.put("max", max);
		}
		return DubboResult.successResult(popupActivityBrickService.findPage(paramMap));
	}

	@Override
	public DubboResult<Long> findPageCount(Integer offset, Integer max) {
		Map<String, Object> paramMap =new HashMap<String, Object>();
		if (offset != null){
			paramMap.put("offset", offset);
		}
		if (max != null){
			paramMap.put("max", max);
		}
		return DubboResult.successResult(popupActivityBrickService.findPageCount(paramMap));
	}
}
