package cn.com.duiba.activity.center.biz.remoteservice.impl.guess;

import cn.com.duiba.activity.center.api.remoteservice.guess.RemoteGuessOrdersStatusChangeService;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersStatusChangeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class RemoteGuessOrdersStatusChangeServiceImpl implements RemoteGuessOrdersStatusChangeService {

    @Autowired
    private GuessOrdersStatusChangeService guessOrdersStatusChangeService;

    @Override
    public int updateStatusToSuccess(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        return guessOrdersStatusChangeService.updateStatusToSuccess(consumerId,guessOrderId,guessOrderExtraId);
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long guessOrderId, String error4admin, String error4developer, String error4consumer) {
        return guessOrdersStatusChangeService.updateStatusToFail(consumerId,guessOrderId,error4admin,error4developer,error4consumer);
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long guessOrderId) {
        return guessOrdersStatusChangeService.updateExchangeStatusToWaitOpen(consumerId,guessOrderId);
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        return guessOrdersStatusChangeService.updateExchangeStatusToWaitOpenAndExtraId(consumerId,guessOrderId,guessOrderExtraId);
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        return guessOrdersStatusChangeService.updateExchangeStatusToWait(consumerId,gameOrderId,itemId,appItemId,prizeId,prizeType,prizeName,prizeFacePrice,couponId);
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        return guessOrdersStatusChangeService.updateExchangeStatusToFail(consumerId,gameOrderId,error4admin,error4developer,error4consumer);
    }

    @Override
    public int doTakePrize(Long consumerId, Long gameOrderId) {
        return guessOrdersStatusChangeService.doTakePrize(consumerId,gameOrderId);
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long gameOrderId) {
        return guessOrdersStatusChangeService.rollbackTakePrize(consumerId,gameOrderId);
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        return guessOrdersStatusChangeService.updateManualOpenPrizeExchangeStatusToWait(consumerId,gameOrderId,itemId,appItemId,prizeId,prizeType,prizeName,prizeFacePrice,couponId);
    }

    @Override
    public int updateIsGivePrize(Long consumerId, Long id, int b) {
        return guessOrdersStatusChangeService.updateIsGivePrize(consumerId,id,b);
    }

    /**
     * 修改订单领奖状态为过期失效
     *
     * @param consumerId
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    @Override
    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        return guessOrdersStatusChangeService.updateExchangeStatusToOverdue(consumerId,id,error4admin,error4developer,error4consumer);
    }

    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        return guessOrdersStatusChangeService.updateStatusToConsumeSuccess(consumerId,gameOrderId);
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long guessOrderExtraId) {
        return guessOrdersStatusChangeService.updateExchangeStatusToWaitOpenAndExtraIdForLuck(consumerId,gameOrderId,guessOrderExtraId);
    }
}
