package cn.com.duiba.activity.center.biz.remoteservice.impl.hdtool;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolSkinDto;
import cn.com.duiba.activity.center.api.remoteservice.hdtool.RemoteHdtoolSkinDataService;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolSkinDataService;
import cn.com.duiba.wolf.dubbo.DubboResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/7/5.
 */
@Service
public class RemoteHdtoolSkinDataServiceImpl implements RemoteHdtoolSkinDataService {

    private static Logger log = LoggerFactory.getLogger(RemoteHdtoolSkinDataServiceImpl.class);

    @Autowired
    private HdtoolSkinDataService hdtoolSkinDataService;


    @Override
    public HdtoolSkinDto createHdtoolSkinData(HdtoolSkinDto hdtoolSkinDto) {
        hdtoolSkinDataService.createHdtoolSkinData(hdtoolSkinDto);
        return hdtoolSkinDto;
    }

    @Override
    public DubboResult<Integer> updateHdtoolSkinData(Long hdtoolId, String type, String dataJson) {
        try{
            return DubboResult.successResult(hdtoolSkinDataService.updateHdtoolSkinData(hdtoolId,type,dataJson));
        }catch(Exception e){
            log.error("更新模版数据异常,class:" + this.getClass().getName() + ",method=updateHdtoolSkinData",e);
            return DubboResult.failResult("更新模版数据异常");
        }

    }
    
    @Override
    public DubboResult<Integer> updateHdtoolSkinDataAppId(Long hdtoolId, String type, String dataJson, Long appId) {
        try{
            return DubboResult.successResult(hdtoolSkinDataService.updateHdtoolSkinDataAppId(hdtoolId,type,dataJson,appId));
        }catch(Exception e){
            log.error("更新模版数据异常,class:" + this.getClass().getName() + ",method=updateHdtoolSkinData",e);
            return DubboResult.failResult("更新模版数据异常");
        }

    }
    
    @Override
    public DubboResult<HdtoolSkinDto> queryBaseHdtoolSkin(Long hdtoolId, String type) {
        try{
            return DubboResult.successResult(hdtoolSkinDataService.queryBaseHdtoolSkin(hdtoolId, type));
        }catch(Exception e){
            log.error("查询模版数据异常,class:" + this.getClass().getName() + ",method=queryBaseHdtoolSkin",e);
            return DubboResult.failResult("查询模版数据异常");
        }
    }
    
    @Override
    public DubboResult<HdtoolSkinDto> queryBaseHdtoolSkinAppId(Long hdtoolId, String type, Long appId) {
        try{
            return DubboResult.successResult(hdtoolSkinDataService.queryBaseHdtoolSkinAppId(hdtoolId, type, appId));
        }catch(Exception e){
            log.error("查询模版数据异常,class:" + this.getClass().getName() + ",method=queryBaseHdtoolSkin",e);
            return DubboResult.failResult("查询模版数据异常");
        }
    }

    @Override
    public DubboResult<String> querySkin(Long hdtoolId, String type) {
        try{
            return DubboResult.successResult(hdtoolSkinDataService.querySkin(hdtoolId, type));
        }catch(Exception e){
            log.error("查询模版数据异常,class:" + this.getClass().getName() + ",method=querySkin",e);
            return DubboResult.failResult("查询模版数据异常");
        }
    }

    @Override
    public DubboResult<String> querySkinAppId(Long hdtoolId, String type, Long appId) {
        try{
            return DubboResult.successResult(hdtoolSkinDataService.querySkinAppId(hdtoolId, type, appId));
        }catch(Exception e){
            log.error("查询模版数据异常,class:" + this.getClass().getName() + ",method=querySkin",e);
            return DubboResult.failResult("查询模版数据异常");
        }
    }
}
