package cn.com.duiba.activity.center.biz.remoteservice.impl.ngame_con;

import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.ngame_con.RemoteNgameOrdersConsumerService;
import cn.com.duiba.activity.center.biz.service.ngame_con.NgameOrdersConsumerService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/16.
 */
@Service
public class RemoteNgameOrdersConsumerServiceImpl implements RemoteNgameOrdersConsumerService {
    @Resource
    private NgameOrdersConsumerService ngameOrdersConsumerService;

    @Override
    public NgameOrdersDto find(Long consumerId, Long gameOrderId) {
        return ngameOrdersConsumerService.find(consumerId, gameOrderId);
    }

    @Override
    public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId) {
        return ngameOrdersConsumerService.findConsumerFreeNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return ngameOrdersConsumerService.findConsumerFreeNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId) {
        return ngameOrdersConsumerService.findConsumerLimitNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return ngameOrdersConsumerService.findConsumerLimitNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public List<NgameOrdersDto> findByIds(Long consumerId, List<Long> ids) {
        return ngameOrdersConsumerService.findByIds(consumerId, ids);
    }

    @Override
    public NgameOrdersDto insert(NgameOrdersDto ngameOrdersDto) {
        ngameOrdersConsumerService.insert(ngameOrdersDto);
        return ngameOrdersDto;
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        return ngameOrdersConsumerService.updateDeveloperBizId(consumerId, id, bizId);
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        return ngameOrdersConsumerService.updateMainOrderId(consumerId, id, mainOrderId, mainOrderNum);
    }

    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        return ngameOrdersConsumerService.updateStatusToConsumeSuccess(consumerId, gameOrderId);
    }

    @Override
    public int updateStatusToSuccess(Long consumerId, Long gameOrderId, Long gameOrderExtraId) {
        return ngameOrdersConsumerService.updateStatusToSuccess(consumerId, gameOrderId, gameOrderExtraId);
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        return ngameOrdersConsumerService.updateStatusToFail(consumerId, gameOrderId, error4admin, error4developer, error4consumer);
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long gameOrderId, String gameDataStr) {
        return ngameOrdersConsumerService.updateExchangeStatusToWaitOpen(consumerId, gameOrderId, gameDataStr);
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long gameOrderId, String gameDataStr, Long gameOrderExtraId) {
        return ngameOrdersConsumerService.updateExchangeStatusToWaitOpenAndExtraId(consumerId, gameOrderId, gameDataStr, gameOrderExtraId);
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long gameOrderId, String gameDataStr, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        return ngameOrdersConsumerService.updateExchangeStatusToWait(consumerId, gameOrderId, gameDataStr, itemId, appItemId, prizeId, prizeType, prizeName, prizeFacePrice, couponId);
    }

    @Override
    public int updateExchangeStatusToOverdue(Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        return ngameOrdersConsumerService.updateExchangeStatusToOverdue(gameOrderId, error4admin, error4developer, error4consumer);
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        return ngameOrdersConsumerService.updateExchangeStatusToFail(consumerId, gameOrderId, error4admin, error4developer, error4consumer);
    }

    @Override
    public int doTakePrize(Long consumerId, Long gameOrderId) {
        return ngameOrdersConsumerService.doTakePrize(consumerId, gameOrderId);
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long gameOrderId) {
        return ngameOrdersConsumerService.rollbackTakePrize(consumerId, gameOrderId);
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        return ngameOrdersConsumerService.updateManualOpenPrizeExchangeStatusToWait(consumerId, gameOrderId, itemId, appItemId, prizeId, prizeType, prizeName, prizeFacePrice, couponId);
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long gameOrderExtraId){
        return ngameOrdersConsumerService.updateExchangeStatusToWaitOpenAndExtraIdForLuck(consumerId, gameOrderId, gameOrderExtraId);
    }
}
