package cn.com.duiba.activity.center.biz.remoteservice.impl.singlelottery;

import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryStockConsumeDto;
import cn.com.duiba.activity.center.api.remoteservice.singlelottery.RemoteSingleLotteryStockConsumeService;
import cn.com.duiba.activity.center.biz.bo.stock.SingleLotteryStockConsumeBo;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryStockConsumeService;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by wenqi.huang on 16/5/20.
 */
@Service
public class RemoteSingleLotteryStockConsumeServiceImpl implements RemoteSingleLotteryStockConsumeService {
    @Resource
    private SingleLotteryStockConsumeBo singleLotteryStockConsumeBo;

    @Resource
    private SingleLotteryStockConsumeService singleLotteryStockConsumeService;

    @Override
    public void consumeDuibaSingleLotteryStock(Long duibaSingleLotteryId, Long appId, Integer optionType, String bizId, String bizSource) throws BusinessException {
        singleLotteryStockConsumeBo.consumeDuibaSingleLotteryStock(duibaSingleLotteryId, appId, optionType, bizId, bizSource);
    }

    @Override
    public void paybackDuibaSingleLotteryStock(String bizId, String bizSource) throws BusinessException {
        singleLotteryStockConsumeBo.paybackDuibaSingleLotteryStock(bizId, bizSource);
    }

    @Override
    public void consumeSingleLotterySpecifyStock(Long duibaSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException {
        singleLotteryStockConsumeBo.consumeSingleLotterySpecifyStock(duibaSingleLotteryId, appId, bizId, bizSource);
    }

    @Override
    public void paybackSingleLotterySpecifyStock(String bizId, String bizSource) throws BusinessException {
        singleLotteryStockConsumeBo.paybackSingleLotterySpecifyStock(bizId, bizSource);
    }

    @Override
    public void consumeDevSingleLotteryStock(Long appSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException {
        singleLotteryStockConsumeBo.consumeDevSingleLotteryStock(appSingleLotteryId, appId, bizId, bizSource);
    }

    @Override
    public void pabackDevSingleLoteryStock(String bizId, String bizSource) throws BusinessException {
        singleLotteryStockConsumeBo.pabackDevSingleLoteryStock(bizId, bizSource);
    }

    @Override
    public SingleLotteryStockConsumeDto insert(SingleLotteryStockConsumeDto singleLotteryStockConsumeDto) {
        singleLotteryStockConsumeService.insert(singleLotteryStockConsumeDto);
        return singleLotteryStockConsumeDto;
    }

    @Override
    public SingleLotteryStockConsumeDto findByBizIdAndSource(String bizId, String bizSource) {
        return singleLotteryStockConsumeService.findByBizIdAndSource(bizId,bizSource);
    }
}
