package cn.com.duiba.activity.center.biz.service.activity;

/**
 * 用户参与活动限制
 * 
 * @author Administrator
 *
 */
public interface ConsumerActivityLimitService {

	/**
	 * 查询用户今日参与活动次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public Integer findConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日参与活动次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public boolean incrConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日参与活动次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public boolean decrConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户永久参与参与活动次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public Integer findConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久参与参与活动次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public boolean incrConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久参与参与活动次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public boolean decrConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户今日免费参与次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public Integer findConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日免费参与次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public boolean incrConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日免费参与次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public boolean decrConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户永久免费参与次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public Integer findConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久免费参与次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public boolean incrConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久免费参与次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public boolean decrConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户活动奖项中奖次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param optionId
	 * @return
	 */
	public Integer findConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId);

	/**
	 * 用户活动奖项中奖次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param optionId
	 * @return
	 */
	public boolean incrConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId);

}
