package cn.com.duiba.activity.center.biz.service.activity;

import cn.com.duiba.activity.center.api.dto.ActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;

import java.util.List;
import java.util.Map;


public interface OperatingActivityService {


    public List<OperatingActivityDto> findGameByAppIdAndActivityId(Long appId, List<Long> duibaActivityIds, Integer type);

    /**
     * 获取能加到计划任务中的app活动
     */
    public List<OperatingActivityDto> findAllAppTasksContent(Long appId);

    /**
     * 获取开启状态的抽奖活动ids
     */
    public List<Long> findOpenLotteryIds();

    /**
     * 获取所有添加了此兑吧专题活动的开启并且非删除状态的开发者活动
     */
    public List<OperatingActivityDto> findAllOpenDuibaActivity(Long duibaActivityId);

    /**
     * @Title: findByAppIdAndDuibaActivityIdAndDeleted
     * @Description: 根据appId和duibaActivityId获取
     * @param appId
     * @param duibaActivityId
     * @return
     */
    public OperatingActivityDto findByAppIdAndDuibaActivityIdAndDeleted(Long appId, Long duibaActivityId, Boolean deleted);

    /**
     * 根据appId和duibaActivityId获取
     */
    public OperatingActivityDto findByAppIdAndDuibaTurntableIdAndDeleted(Long appId, Long duibaTurntableId, Boolean deleted);

    /**
     * 根据appId和gameConfigDuibaId获取
     */
    public OperatingActivityDto findByAppIdAndGameConfigDuibaIdAndDeleted(Long appId, Long gameConfigDuibaId, Boolean deleted);

    /**
     * 根据appId和duibaSingleLotteryId获取
     */
    public OperatingActivityDto findByAppIdAndDuibaSingleLotteryIdAndDeleted(Long appId, Long duibaSingleLotteryId, Boolean deleted);

    /**
     * 根据appId和duibaQuestionAnswerId获取
     */
    public OperatingActivityDto findByAppIdAndDuibaQuestionAnswerIdAndDeleted(Long appId, Long duibaQuestionAnswerId, Boolean deleted);

    /**
     * 根据appId和duibaSeckillId获取
     */
    public OperatingActivityDto findByAppIdAndDuibaSeckillIdAndDeleted(Long appId, Long duibaSeckillId, Boolean deleted);

    /**
     * 根据appId和duibaHdtoolId获取
     */
    public OperatingActivityDto findByAppIdAndDuibaHdtoolIdAndDeleted(Long appId, Long duibaHdtoolId, Boolean deleted);

    /**
     * 根据appId和duibaQuizzId获取
     */
    public OperatingActivityDto findByAppIdAndDuibaQuizzIdAndDeleted(Long appId, Long duibaQuizzId, Boolean deleted);

    /**
     * 根据appId和AppSingleLotteryId获取
     */
    public OperatingActivityDto findByAppIdAndAppSingleLotteryIdAndDeleted(Long appId, Long appSingleLotteryId, Boolean deleted);

    public OperatingActivityDto findByAppIdAndAppManualLotteryAndDeleted(Long appId, Long appManualLotteryId, Boolean deleted);

    public Long countActivity(Map<String, Object> params);

    public List<ActivityDto> findActivityList(Map<String, Object> params);

    public List<ActivityDto> findRecommendActivityList(Long appId);


    public List<ActivityDto> findActivityListByParent(Map<String, Object> params);

    public Integer deleteTurntable(Long turntableId, Long appId, Boolean delete, Integer status);

    /**
     * @Title: findAppIdsByDuibaActivityId
     * @Description: 根据兑吧活动ID 获取所添加的AppId列表
     * @return
     */
    public List<Long> findAppIdsByDuibaActivityId(Long duibaActivityId);

    /**
     * 根据单品抽奖ID获取APPID列表
     */
    public List<Long> findAppIdsBySingleLotteryId(Long singleLotteryId);

    public List<Long> findAppIdsByActivityIdAndType(Long activityId, Integer type);

    /**
     * 根据兑吧单品抽奖活动ID 获取所添加的AppId列表
     */
    public List<Long> findAppIdsByDuibaSingleLotteryId(Long duibaSingleLotteryId);

    public Integer countAppByActivityIdAndType(Long activityId, Integer type);

    /**
     * 根据兑吧活动ids获取List<OperatingActivityDto>
     */
    public List<OperatingActivityDto> findAllByDuibaActivityIds(List<Long> daIdList);

    public List<OperatingActivityDto> findAllByActivityIdsAndType(List<Long> activityIds, Integer type);

    /**
     * 根据兑吧单品抽奖ids获取List<OperatingActivityDto>
     */
    public List<OperatingActivityDto> findAllByDuibaSingleLotteryIds(List<Long> dslIdList);

    /**
     * 根据兑吧活动id获取List<Long>
     */
    public List<Long> findIdsByDuibaActivityId(Long duibaActivityId);

    /**
     * 关闭所有已经添加该duibaActivity的活动
     */
    public int updateStatusByDuibaActivityId(Integer status, Long duibaActivityId);

    /**
     * 关闭所有已经添加该duibaSingleLottery的活动
     */
    public int updateStatusBySingleLotteryId(Integer status, Long singleLotteryId);

    public int updateVisitTimes(Long id);

    /**
     * 根据兑吧单品抽奖ID获取开发者活动ids
     */
    public List<Long> findIdsBySingleLotteryId(Long duibaSingleLotteryId);

    /**
     * 根据类型查询所有
     */
    public List<OperatingActivityDto> findAllByType(Integer type);

    /**
     * 根据duibaSingleLotteryId查询
     */
    public List<OperatingActivityDto> findAllBySingleLotteryId(Long duibaSingleLotteryId);

    public List<OperatingActivityDto> findAllBySingleLotteryIdAndDeleted(Long duibaSingleLotteryId, Boolean deleted);

    public List<OperatingActivityDto> findAllByDuibaSeckillIdAndDeleted(Long duibaSeckillId, Boolean deleted);

    public List<OperatingActivityDto> findAllByDuibaActivityId(Long duibaActivityId);

    public List<OperatingActivityDto> findAllByDuibaSecondsKillId(Long duibaSecondsKillId);

    public List<OperatingActivityDto> findAllByDuibaActivityIdAndDeleted(Long duibaActivityId, Boolean deleted);

    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerIdAndDeleted(Long duibaQuestionAnswerId, Boolean deleted);

    public List<OperatingActivityDto> findAllByDuibaQuizzIdAndDeleted(Long duibaQuizzId, Boolean deleted);

    public void updateStatusByActivityIdAndType(Long activityId, Integer type, Integer status);

    public OperatingActivityDto findByActivityIdAndTypeAndAppIdAndDeleted(Long activityId, Integer type, Long appId, Boolean deleted);

    public List<Long> findIdsByDuibaActivityIdAndType(Long duibaActivityId, Integer type);

    public List<OperatingActivityDto> findSingleLotteryOperaList(List<Long> activityIds, Long appId);

    /**
     * 用于查询子活动
     */
    public OperatingActivityDto findByActivityIdAndParentIdAndTypeAndAppId(Long duibaActivityId, Long parentActivityId, Integer type, Long appId);

    public void deleteByParentActivityIds(List<Long> parentIds);

    public OperatingActivityDto findOperatingSingleLottery(Long activityId, Long appId);

    public List<OperatingActivityDto> findAllByIds(List<Long> ids);

    public int updateManualLotteryByIds(List<Long> ids);

    /**
     * 查询某个App的所有正在启用状态的运营活动
     */
    public List<OperatingActivityDto> findAllEnabledActivies(Long appId);

    /**
     * 获取开启状态的活动
     */
    public List<OperatingActivityDto> findActiveActivity(Long appId);

    public List<Long> findAllVirtualInTurntable(Long appId);

    public List<Long> findAllVirtualInSingleLottery(Long appId);

    public List<Long> findAllVirtualInHdTool(Long appId);

    public OperatingActivityDto find(Long id);

    public void insert(OperatingActivityDto operatingActivityDto);

    public int update(OperatingActivityDto operatingActivityDto);

    /**
     * 根据兑吧秒杀专题活动ID 获取所添加的AppId列表
     */
    public List<Long> findAppIdsByDuibaSecondsKillId(Long duibaSecondsKillId);

    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId);

    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerId(Long duibaQuestionAnswerId);

    public List<OperatingActivityDto> findAllByDuibaQuizzId(Long duibaQuizzId);

    public List<OperatingActivityDto> findAllByDuibaSeckillId(Long duibaSeckillId);

    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityIdAndDeleted(Long duibaSecondsKillActivityId, Boolean deleted);

    public void updateStatusByDuibaSecondsKillActivityId(Integer status, Long duibaSecondsKillActivityId);

    public OperatingActivityDto findGameOperatingActivity(Long appId, Long gameConfigDuibaId, Integer gameType);

    public OperatingActivityDto findQuestionAnswerOperatingActivity(Long appId, Long activityId);

    public OperatingActivityDto findSecondsKillOperatingActivity(Long appId, Long activityId);

    public OperatingActivityDto findByAppIdAndDuibaGameIdAndDeleted(Long appId, Long duibaGameId, Boolean deleted);

    public ActivityDto findByAppIdLimit(Long appId, Long activityId);

    //from developer project
    public List<OperatingActivityDto> findAllByAppId(Long appId);

    public OperatingActivityDto findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(Long appId, Long duibaSecondsKillActivityId, Boolean deleted);

    public List<OperatingActivityDto> findDuibaQuestionAnswerByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    public List<OperatingActivityDto> findDuibaQuizzByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    public List<OperatingActivityDto> findDuibaSeckillByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    public List<ActivityDto> findOnlineActivity(Map<String, Object> params);

    public List<ActivityDto> findOnlineActivityWithOutTopic(Map<String, Object> params);

    public List<OperatingActivityDto> findAllByDuibaGuessIdAndDeleted(Long duibaGuessId, Boolean deleted);
    public List<Long> findAppIdsByDuibaGuessId(Long duibaGuessId);
    public List<OperatingActivityDto> findAllByDuibaNgameId(Long duibaNgameId);
    public List<OperatingActivityDto> findAllByDuibaGuessId(Long duibaGuessId);

    public List<OperatingActivityDto> findDuibaNgameByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    public List<OperatingActivityDto> findDuibaGuessByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    /**
     * 根据appId和duibaQuizzId获取
     */
    public OperatingActivityDto findByAppIdAndDuibaGuessIdAndDeleted(Long appId, Long duibaGuessId, Boolean deleted);
    public OperatingActivityDto findByAppIdAndDuibaNgameActivityIdAndDeleted(Long appId, Long duibaNgameActivityId, Boolean deleted);
    public OperatingActivityDto findByAppIdAndDuibaGuessActivityIdAndDeleted(Long appId, Long duibaGuessActivityId, Boolean deleted);

    List<Long> findSeckillIdsByActivityId(Long duibaSeckillId);
    public OperatingActivityDto findById(Long id);
	public List<Long> findAppIdsByIds(List<Long> ids);
	public void insertUnique(OperatingActivityDto operatingActivityDto);
	
	public int updateVisitTimes(Long operatingActivityId, int offset);

    public List<OperatingActivityDto> findByActivityId(Long activityId);
}
