package cn.com.duiba.activity.center.biz.service.chaos;

import java.util.List;

import cn.com.duiba.activity.center.biz.entity.chaos.ActivityCategorySpecifyEntity;
/**
 * 活动子页面定向
 * Author ：zhengjy <br/>
 * Create Time：2016年9月9日 下午7:25:21 <br/>
 */
public interface ActivityCategorySpecifyService {
	
	/**
	 * 活动子页面-查询活动定向开发者列表
	 * @param activityCategoryId 
	 * @return 
	 */
	public List<ActivityCategorySpecifyEntity> findAll(Long activityCategoryId,Integer pageIndex,Integer pageSize);
	
	/**
	 * 活动子页面-查询活动定向开发者count
	 * @author zhengjy
	 * @param activityCategoryId 
	 * @return
	 */
	public Integer findSpecifyAllCount(Long activityCategoryId,Integer pageIndex,Integer pageSize);
	
	/**
	 * 活动子页面-保存开发者定向
	 * @author zhengjy
	 * @param activityCategorySpecifyEntity
	 * @return
	 */
	public Boolean specifySave(ActivityCategorySpecifyEntity activityCategorySpecifyEntity);
	
	/**
	 * 活动子页面-删除开发者定向
	 * @author zhengjy
	 * @param id
	 * @return
	 */
	public Boolean specifyDelete(Long id);
	
	/**
	 * 活动子页面-查询app下定向活动列表
	 * @author zhengjy
	 * @param Long appId 
	 * @return 
	 */
	public List<ActivityCategorySpecifyEntity> findByAppSpecifys(Long appId);
	
	/**
     * 查询活动子页面定向app白名单
     * @param activityCategoryId 子页面ID
     * @return 
     */
    public List<Long> findAppIdList(Long activityCategoryId);
}
