package cn.com.duiba.activity.center.biz.service.chaos.impl;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.activity.center.biz.constant.MemcachedSpace;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryDao;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategorySpecifyDao;
import cn.com.duiba.activity.center.biz.entity.chaos.ActivityCategorySpecifyEntity;
import cn.com.duiba.activity.center.biz.service.chaos.ActivityCategorySpecifyService;
import cn.com.duiba.wolf.cache.CacheClient;

/**
 * 活动子页面定向 Author ：zhengjy <br/>
 * Create Time：2016年9月9日 下午7:26:54 <br/>
 */
@Service
public class ActivityCategorySpecifyServiceImpl implements ActivityCategorySpecifyService {

    @Autowired
    private ActivityCategorySpecifyDao activityCategorySpecifyDao;

    @Autowired
    private ActivityCategoryDao        activityCategoryDao;
    
    @Autowired
    private CacheClient                memcachedClient;

    @Override
    public List<ActivityCategorySpecifyEntity> findAll(Long activityCategoryId, Integer pageIndex, Integer pageSize) {
        return activityCategorySpecifyDao.selectSpecifyAll(activityCategoryId, pageIndex, pageSize);
    }

    @Override
    public Integer findSpecifyAllCount(Long activityCategoryId, Integer pageIndex, Integer pageSize) {
        return activityCategorySpecifyDao.selectSpecifyAllCount(activityCategoryId, pageIndex, pageSize);
    }

    @Override
    @Transactional(DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean specifySave(ActivityCategorySpecifyEntity activityCategorySpecifyEntity) {
        activityCategorySpecifyDao.insertSpecify(activityCategorySpecifyEntity);
        activityCategoryDao.updateCategorySpecify(activityCategorySpecifyEntity.getActivityCategoryId(), 1);
        memcachedClient.remove(getCategoryKey(activityCategorySpecifyEntity.getActivityCategoryId()));
        return true;
    }

    @Override
    @Transactional(DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean specifyDelete(Long id) {
        ActivityCategorySpecifyEntity ac = activityCategorySpecifyDao.selectById(id);
        activityCategorySpecifyDao.deleteSpecify(id);
        memcachedClient.remove(getCategoryKey(ac.getActivityCategoryId()));
        // 如果当前子页面未定向app，则关闭定向开关
        if (activityCategorySpecifyDao.selectSpecifyAllCount(ac.getActivityCategoryId(), 1, 20) <= 0) {
            activityCategoryDao.updateCategorySpecify(ac.getActivityCategoryId(), 0);
        }
        return true;
    }

    @Override
    public List<ActivityCategorySpecifyEntity> findByAppSpecifys(Long appId) {
        return activityCategorySpecifyDao.selectByAppSpecifys(appId);
    }

    @Override
    public List<Long> findAppIdList(Long activityCategoryId) {
        List<Long> appIdList = memcachedClient.get(getCategoryKey(activityCategoryId));
        if(CollectionUtils.isEmpty(appIdList)){
            appIdList = activityCategorySpecifyDao.findAppIdList(activityCategoryId);
            if(CollectionUtils.isNotEmpty(appIdList)){
                memcachedClient.set(getCategoryKey(activityCategoryId), appIdList, 600);
            }
        }
        return appIdList;
    }

    private String getCategoryKey(Long activityCategoryId){
        return MemcachedSpace.MS_CATEGORY_SPECIFY_CACHE + activityCategoryId;
    }
}
