package cn.com.duiba.activity.center.biz.service.commonactivity.impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.enums.DuibaActivityTypeEnum;
import cn.com.duiba.activity.center.biz.constant.DomainConfigureConstant;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityEntity;
import cn.com.duiba.activity.center.biz.service.commonactivity.ActivityToolService;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * Created by gyf .
 */
@Service("activityToolService")
public class ActivityToolServiceImpl implements ActivityToolService {

    @Autowired
    private DuibaActivityToolServiceImpl            duibaActivityToolServiceImpl;
    @Autowired
    private DuibaGuessToolServiceImpl               duibaGuessToolServiceImpl;
    @Autowired
    private DuibaHdtoolToolServiceImpl              duibaHdtoolToolServiceImpl;
    @Autowired
    private DuibaNgameToolServiceImpl               duibaNgameToolServiceImpl;
    @Autowired
    private DuibaQuestionAnswerToolServiceImpl      duibaQuestionAnswerToolServiceImpl;
    @Autowired
    private DuibaQuizzToolServiceImpl               duibaQuizzToolServiceImpl;
    @Autowired
    private DuibaSeckillToolServiceImpl             duibaSeckillToolServiceImpl;
    @Autowired
    private DuibaSecondsKillActivityToolServiceImpl duibaSecondsKillActivityToolServiceImpl;
    @Autowired
    private DuibaSingleLotteryToolServiceImpl       duibaSingleLotteryToolServiceImpl;
    @Autowired
    private OperatingActivityDao                    operatingActivityDao;

    private ActivityToolServiceAdapter service(DuibaActivityTypeEnum type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case DUIBA_ACTIVITY:
                return duibaActivityToolServiceImpl;
            case DUIBA_GUESS:
                return duibaGuessToolServiceImpl;
            case DUIBA_HDTOOL:
                return duibaHdtoolToolServiceImpl;
            case DUIBA_NGAME:
                return duibaNgameToolServiceImpl;
            case DUIBA_QUESTION_ANSWER:
                return duibaQuestionAnswerToolServiceImpl;
            case DUIBA_QUIZZ:
                return duibaQuizzToolServiceImpl;
            case DUIBA_SECKILL:
                return duibaSeckillToolServiceImpl;
            case DUIBA_SECONDS_KILL_ACTIVITY:
                return duibaSecondsKillActivityToolServiceImpl;
            case DUIBA_SINGLE_LOTTERY:
                return duibaSingleLotteryToolServiceImpl;
            default:
                return null;
        }
    }

    @Override
    public String getTitle(Long activityId, DuibaActivityTypeEnum type) {
        ActivityToolServiceAdapter service = service(type);
        if (service == null) {
            throw new RuntimeException("类型参数不全");
        }
        return service.getTitle(activityId);
    }

    @Override
    public Map<Long, String> getMobileUrlMap(List<Tuple.Tuple2<Integer, Long>> activities) {
        if (CollectionUtils.isEmpty(activities)) {
            return Collections.emptyMap();
        }
        Map<Long, String> urlMap = new HashMap<>();
        for (Tuple.Tuple2<Integer, Long> it : activities) {
            urlMap.put(it._2(), getUrlByType(it._1(), it._2()));
        }
        return urlMap;
    }

    /**
     * 获取 url
     * @param type
     * @param operatingActivityId
     * @return
     */
    private String getUrlByType(Integer type, Long operatingActivityId) {
        String url = null;
        if (OperatingActivityDto.TypeDuibaActivity == type) {
            url = String.format("%s/consumerDuibaActivity/list/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (OperatingActivityDto.TypeDuibaSingleLottery == type || OperatingActivityDto.TypeAppSingleLottery == type) {
            url = String.format("%s/singleLottery/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (OperatingActivityDto.TypeAppManualLottery == type) {
            url = String.format("%s/ConsumerAppManualLottery/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeShakeLottery == type) {
            url = String.format("%s/shake/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeScratchCard == type) {
            url = String.format("%s/ScratchCard/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeHdToolTiger == type) {
            url = String.format("%s/tiger/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeHdToolFlop == type) {
            url = String.format("%s/flop/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeHdToolSmashg == type) {
            url = String.format("%s/smashg/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeHdToolTurntable == type) {
            url = String.format("%s/turntableNew/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeDuibaQuestionAnswer == type) {
            url = String.format("%s/question/index?id=%s&dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeDuibaQuizz == type) {
            url = String.format("%s/quizz/index?id=%s&dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeSecondsKill == type) {
            url = String.format("%s/SecondsKillActivity/index?id=%s&dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeDuibaSeckill == type) {
            url = String.format("%s/seckill/index/%s?dbnewopen",
                                DomainConfigureConstant.getAppDuibaSeckillDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeDuibaNgame == type) {
            url = String.format("%s/ngame/index?id=%s&dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        } else if (OperatingActivityDto.TypeDuibaGuess == type) {
            url = String.format("%s/guess/index?id=%s&dbnewopen",
                                DomainConfigureConstant.getAppDuibaCreditsDomainName(),operatingActivityId);
        }
        return url;
    }

    @Override
    public OperatingActivityDto findAppActivity(Long appId, Long activityId, Integer type) {
        if (appId == null || activityId == null || type == null) {
            return null;
        }
        OperatingActivityEntity entity = operatingActivityDao.findByActivityIdAndTypeAndAppIdAndDeleted(activityId, type, appId, Boolean.FALSE);
        if (entity == null) {
            return null;
        }
        OperatingActivityDto dto = new OperatingActivityDto();
        BeanUtils.copy(entity, dto);
        return dto;
    }

    @Override
    public List<OperatingActivityDto> findAppActivitys(Long appId, List<Tuple.Tuple2<Integer, Long>> activities) {
        if (appId == null || CollectionUtils.isEmpty(activities)) {
            return null;
        }
        List<OperatingActivityDto> result = new ArrayList<>();
        OperatingActivityDto dto = null;
        OperatingActivityEntity entity = null;
        for (Tuple.Tuple2<Integer, Long> it : activities) {
            entity = operatingActivityDao.findByActivityIdAndTypeAndAppIdAndDeleted(it._2(), it._1(), appId, Boolean.FALSE);
            if (entity == null) {
                continue;
            }
            dto = new OperatingActivityDto();
            BeanUtils.copy(entity, dto);
            result.add(dto);
        }
        return result;
    }

}
