package cn.com.duiba.activity.center.biz.service.commonactivity.impl;

import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessEntity;
import cn.com.duiba.activity.center.biz.service.commonactivity.ActivityToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 竞猜.
 */
@Service("duibaGuessToolServiceImpl")
public class DuibaGuessToolServiceImpl extends ActivityToolService.ActivityToolServiceAdapter {

    @Autowired
    private DuibaGuessDao duibaGuessDao;

    @Override
    public String getTitle(Long activityId) {
        if (activityId == null) {
            throw new RuntimeException("参数不全");
        }
        DuibaGuessEntity entity = duibaGuessDao.find(activityId);
        if (entity == null || entity.getDeleted()) {
            throw new RuntimeException("活动不存在");
        }
        return entity.getTitle();
    }

}
