package cn.com.duiba.activity.center.biz.service.commonactivity.impl;

import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameEntity;
import cn.com.duiba.activity.center.biz.service.commonactivity.ActivityToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 新游戏.
 */
@Service("duibaNgameToolServiceImpl")
public class DuibaNgameToolServiceImpl extends ActivityToolService.ActivityToolServiceAdapter {

    @Autowired
    private DuibaNgameDao duibaNgameDao;

    @Override
    public String getTitle(Long activityId) {
        if (activityId == null) {
            throw new RuntimeException("参数不全");
        }
        DuibaNgameEntity entity = duibaNgameDao.find(activityId);
        if (entity == null || entity.getDeleted()) {
            throw new RuntimeException("活动不存在");
        }
        return entity.getTitle();
    }

}
