package cn.com.duiba.activity.center.biz.service.creditgame.impl;

import java.util.List;

import cn.com.duiba.activity.center.biz.dao.GenericCURDDao;
import cn.com.duiba.activity.center.biz.dao.creditgame.CreditGameDao;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.service.AbstractGenericCURDService;

/**
 * 积分游戏Service实现类
 * @author jyc
 * @since 2016-09-06
 */
@Service
public class CreditGameServiceImpl extends AbstractGenericCURDService<CreditGameEntity,Long> implements CreditGameService {

    @Autowired
    private CreditGameDao creditGameDao;

    protected  GenericCURDDao<CreditGameEntity, Long> getDao(){
        return creditGameDao;
    }

    @Override
    public CreditGameEntity getCreditGameById(Long creditGameId){
        return creditGameDao.queryById(creditGameId);
    }

    @Override
    public List<CreditGameEntity> findPage(String title, Integer offset, Integer max) {
        return creditGameDao.selectList(title, offset, max);
    }

    @Override
    public Long findCount(String title) {
        return creditGameDao.selectCount(title);
    }

    @Override
    public int updateStatus(Long id, byte status) {
        CreditGameEntity entity = new CreditGameEntity();
        entity.setId(id);
        entity.setCreditGameStatus(status);
        return this.creditGameDao.update(entity);
    }
    @Override
    public List<Long> findAutoOff() {
        return creditGameDao.selectAutoOff();
    }


}
