package cn.com.duiba.activity.center.biz.service.direct.impl;

import cn.com.duiba.activity.center.api.dto.direct.DuibaActivityAppSpecifyNewDto;
import cn.com.duiba.activity.center.biz.dao.direct.DuibaActivityAppSpecifyNewDao;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by suyuanlong on 16/7/20.
 */
@Service
public class DuibaActivityAppSpecifyNewServiceImpl implements DuibaActivityAppSpecifyNewService {

    @Autowired
    private DuibaActivityAppSpecifyNewDao duibaActivityAppSpecifyNewDao;

    @Override
    public DuibaActivityAppSpecifyNewDto findAppSpecifyByActivityIdAndAppIdAndActivityType(Long activityId, Long appId, String activityType) {
        return duibaActivityAppSpecifyNewDao.findAppSpecifyByActivityIdAndAppIdAndActivityType(activityId,appId,activityType);
    }

    @Override
    public List<DuibaActivityAppSpecifyNewDto> findAppSpecifyByActivityIdAndActivityType(Long activityId, String type) {
        return duibaActivityAppSpecifyNewDao.findAppSpecifyByActivityIdAndActivityType(activityId,type);
    }

    @Override
    public Long insertAppSpecify(DuibaActivityAppSpecifyNewDto bto) {
        if(null==bto.getAppId() ||  null==bto.getRelationId() || null==bto.getRelationType()){
            return null;
        }
        if(!DuibaActivityAppSpecifyNewDto.ACTIVITY_TYPE_MAP.containsKey(bto.getRelationType())){
            return -1l;
        }

        if(null!=bto.getHdType() && !DuibaActivityAppSpecifyNewDto.ACTIVITY_TYPE_MAP.containsKey(bto.getHdType())){
           return -2l;
        }

        DuibaActivityAppSpecifyNewDto newDto= duibaActivityAppSpecifyNewDao.findAppSpecifyByActivityIdAndAppIdAndActivityType(bto.getRelationId(),bto.getAppId(),bto.getRelationType());
        if(null==newDto){
           return duibaActivityAppSpecifyNewDao.insertAppSpecify(bto);
        }else{
            return null;
        }
    }

    @Override
    public int deleteAppSpecifyById(Long id) {
        return duibaActivityAppSpecifyNewDao.deleteAppSpecifyById(id);
    }

    @Override
    public DuibaActivityAppSpecifyNewDto findAppSpecifyById(Long id) {

        return duibaActivityAppSpecifyNewDao.findAppSpecifyById(id);
    }
}
