package cn.com.duiba.activity.center.biz.service.duibaactivity.impl;

import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityAppSpecifyDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.biz.dao.duibaactivity.DuibaActivityAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.duibaactivity.DuibaActivityAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.duibaactivity.DuibaActivityAppSpecifyService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/23.
 */
@Service
public class DuibaActivityAppSpecifyServiceImpl implements DuibaActivityAppSpecifyService {
    @Resource
    private DuibaActivityAppSpecifyDao duibaActivityAppSpecifyDao;

    @Override
    public List<DuibaActivityAppSpecifyDto> findDuiBaActivitySpecifyDO(Long duibaActivityId) {
        return BeanUtils.copyList(duibaActivityAppSpecifyDao.findDuiBaActivitySpecifyDO(duibaActivityId),DuibaActivityAppSpecifyDto.class);
    }

    @Override
    public void delete(Long id) {
        duibaActivityAppSpecifyDao.delete(id);
    }

    @Override
    public DuibaActivityAppSpecifyDto findByDuibaActivityAndApp(Long duibaActivityId, Long appId) {
        return BeanUtils.copy(duibaActivityAppSpecifyDao.findByDuibaActivityAndApp(duibaActivityId, appId),DuibaActivityAppSpecifyDto.class);
    }

    @Override
    public Map<Long,DuibaActivityAppSpecifyDto> findByDuibaActivitysAndApp(List<Long> duibaActivityIds, Long appId){
        List<DuibaActivityAppSpecifyEntity> list = duibaActivityAppSpecifyDao.findByDuibaActivitysAndApp(duibaActivityIds, appId);
        Map<Long,DuibaActivityAppSpecifyDto> map = new HashMap<Long, DuibaActivityAppSpecifyDto>();
        for(DuibaActivityAppSpecifyEntity e : list){
            map.put(e.getDuibaActivityId(), BeanUtils.copy(e, DuibaActivityAppSpecifyDto.class));
        }

        return map;
    }

    @Override
    public void insert(DuibaActivityAppSpecifyDto duibaActivityAppSpecifyDO) {
        DuibaActivityAppSpecifyEntity entity=new DuibaActivityAppSpecifyEntity(true);
        BeanUtils.copy(duibaActivityAppSpecifyDO,entity);
        duibaActivityAppSpecifyDao.insert(entity);
        duibaActivityAppSpecifyDO.setId(entity.getId());
    }

    @Override
    public DuibaActivityAppSpecifyDto find(Long id) {
        return BeanUtils.copy(duibaActivityAppSpecifyDao.find(id),DuibaActivityAppSpecifyDto.class);
    }
}
