package cn.com.duiba.activity.center.biz.service.game;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersDto;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOrdersEntity;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface DuibaQuestionAnswerOrdersService {

	void insert(DuibaQuestionAnswerOrdersDto order);

	void updateStatusToConsumeSuccess(Long id);

	DuibaQuestionAnswerOrdersDto find(Long id);

	void updateStatusToConsumeFail(Long id, String error4admin, String error4developer, String error4consumer);
	
	void updateStatusToSuccess(Long id);

	void updateDeveloperBizId(Long questionOrderId, String bizId);

	public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);
	
	public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);
	
	public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);
	
	public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	void updateExchangeStatusToFail(Long questionOrderId, String error4admin, String error4developer, String error4consumer);

	void updateMainOrderId(Long questionOrderId, Long mainOrderId, String mainOrderNum);

	int updateExchangeStatusToOverdue(Long questionOrderId, String error4admin, String error4developer, String error4consumer);
	
	int updateExchangeStatusToSucess(Long questionOrderId, String error4admin, String error4developer, String error4consumer);
	
	int updateExchangeStatusToWait(Long questionOrderId, String error4admin, String error4developer, String error4consumer);

	int doTakePrize(Long questionOrderId);

	void rollbackTakePrize(Long questionOrderId);

	List<Long> findOverdueOrder();

	List<DuibaQuestionAnswerOrdersDto> findByIds(List<Long> questionIds);

    /**
     * @param questionOrdersDO
     */
    void updatePrizeInfo(DuibaQuestionAnswerOrdersDto questionOrdersDO);

    /**
     * @param orderId
     * @param rightCount
     */
    void updateScore(Long orderId, Integer rightCount);

    /**
     * @param id
     * @param bizId
     * @return
     */
    DuibaQuestionAnswerOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId);

    List<DuibaQuestionAnswerOrdersDto> findQuestionOrderLimit50(Long appId, Long activityId);

	int updateLuckPrizeNone(DuibaQuestionAnswerOrdersDto order);

	List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids);

	List<DuibaQuestionAnswerOrdersDto> findByLimit(Map<String, Object> queryMap);

	Long totalCount(Map<String, Object> queryMap);
}
