package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOptionsDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOptionsEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOptionsService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static cn.com.duiba.wolf.utils.BeanUtils.copy;

/**
 * Created by wenqi.huang on 16/5/31.
 */
@Service
public class DuibaQuestionAnswerOptionsServiceImpl implements DuibaQuestionAnswerOptionsService {
    @Resource
    private DuibaQuestionAnswerOptionsDao duibaQuestionAnswerOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyByQuestionId(Long duibaQuestionId){
        return CacheConstants.KEY_DUIBA_QUESTION_ANSWER_OPTIONS_BY_QID + duibaQuestionId;
    }
    private String getCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_QUESTION_ANSWER_OPTIONS_BY_ID + id;
    }

    @Override
    public List<DuibaQuestionAnswerOptionsDto> findOptionsByQuestionId(Long duibaQuestionId) {
        String key = getCacheKeyByQuestionId(duibaQuestionId);
        List<DuibaQuestionAnswerOptionsDto> list = cacheClient.get(key);
        if(list == null){
            list = BeanUtils.copyList(duibaQuestionAnswerOptionsDao.findOptionsByQuestionId(duibaQuestionId), DuibaQuestionAnswerOptionsDto.class);
            cacheClient.set(key, list, 1, TimeUnit.HOURS);
        }
        return list;
    }

    public Map<Long, List<DuibaQuestionAnswerOptionsDto>> findOptionsByQuestionIds(List<Long> duibaQuestionIds){
        List<DuibaQuestionAnswerOptionsEntity> list = duibaQuestionAnswerOptionsDao.findOptionsByQuestionIds(duibaQuestionIds);
        Map<Long, List<DuibaQuestionAnswerOptionsDto>> map = new HashMap<>();
        for(DuibaQuestionAnswerOptionsEntity e : list){
            List<DuibaQuestionAnswerOptionsDto> innerList = map.get(e.getDuibaQuestionAnswerId());
            if(innerList == null){
                innerList = new ArrayList<>();
                map.put(e.getDuibaQuestionAnswerId(), innerList);
            }
            innerList.add(BeanUtils.copy(e, DuibaQuestionAnswerOptionsDto.class));
        }

        return map;
    }

    @Override
    public DuibaQuestionAnswerOptionsDto find(Long id) {
        String key = getCacheKeyById(id);
        DuibaQuestionAnswerOptionsDto dto = cacheClient.get(key);
        if(dto == null) {
            dto = BeanUtils.copy(duibaQuestionAnswerOptionsDao.find(id), DuibaQuestionAnswerOptionsDto.class);
            cacheClient.set(key, dto, 1, TimeUnit.HOURS);
        }
        return dto;
    }

    @Override
    public DuibaQuestionAnswerOptionsDto findById(Long id) {
        return copy(duibaQuestionAnswerOptionsDao.findById(id), DuibaQuestionAnswerOptionsDto.class);
    }

    @Override
    public int delete(List<Long> ids) {
        if(ids == null || ids.isEmpty()){
            return 0;
        }
        List<DuibaQuestionAnswerOptionsEntity> list = duibaQuestionAnswerOptionsDao.findByIds(ids);
        int ret = duibaQuestionAnswerOptionsDao.delete(ids);
        if(ret > 0) {
            for (DuibaQuestionAnswerOptionsEntity e : list) {
                cacheClient.remove(getCacheKeyByQuestionId(e.getDuibaQuestionAnswerId()));
            }
            for (Long id : ids) {
                cacheClient.remove(getCacheKeyById(id));
            }
        }
        return ret;
    }

    @Override
    public void insert(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO) {
        DuibaQuestionAnswerOptionsEntity e = copy(questionAnswerOptionsDO, DuibaQuestionAnswerOptionsEntity.class);
        duibaQuestionAnswerOptionsDao.insert(e);
        questionAnswerOptionsDO.setId(e.getId());
        cacheClient.remove(getCacheKeyByQuestionId(e.getDuibaQuestionAnswerId()));
    }

    @Override
    public int update(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO) {
        DuibaQuestionAnswerOptionsEntity e = duibaQuestionAnswerOptionsDao.find(questionAnswerOptionsDO.getId());
        int ret = duibaQuestionAnswerOptionsDao.update(copy(questionAnswerOptionsDO, DuibaQuestionAnswerOptionsEntity.class));
        cacheClient.remove(getCacheKeyByQuestionId(e.getDuibaQuestionAnswerId()));
        cacheClient.remove(getCacheKeyById(e.getId()));
        return ret;
    }

}
