package cn.com.duiba.activity.center.biz.service.game.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.game.GameOrdersDto;
import cn.com.duiba.activity.center.biz.entity.game.GameOrdersEntity;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersSimpleDto;
import cn.com.duiba.activity.center.biz.dao.game.GameOrdersSimpleDao;
import cn.com.duiba.activity.center.biz.service.game.GameOrdersSimpleService;

@Service
public class GameOrdersSimpleServiceImpl implements GameOrdersSimpleService {

    @Autowired
    private GameOrdersSimpleDao gameOrdersSimpleDao;

    @Override
    public GameOrdersDto find(Long gameOrderId) {
        return BeanUtils.copy(gameOrdersSimpleDao.find(gameOrderId),GameOrdersDto.class);
    }

    @Override
    public List<GameOrdersDto> findByIds(List<Long> ids) {
        return BeanUtils.copyList(gameOrdersSimpleDao.findByIds(ids),GameOrdersDto.class);
    }

    @Override
    public void insert(GameOrdersDto gameOrdersDto) {
        GameOrdersEntity gameOrdersEntity = BeanUtils.copy(gameOrdersDto, GameOrdersEntity.class);
        gameOrdersSimpleDao.insert(gameOrdersEntity);
        gameOrdersDto.setId(gameOrdersEntity.getId());
    }

    @Override
    public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId) {
        return gameOrdersSimpleDao.findConsumerFreeNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return gameOrdersSimpleDao.findConsumerLimitNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId) {
        return gameOrdersSimpleDao.findConsumerLimitNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return gameOrdersSimpleDao.findConsumerLimitNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public GameOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        return BeanUtils.copy(gameOrdersSimpleDao.findByAppAndDeveloperBizId(appId, bizId),GameOrdersDto.class);
    }

    @Override
    public Integer countConsumerByPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        return gameOrdersSimpleDao.countConsumerByPrizeId(consumerId, operatingActivityId, prizeId);
    }

    @Override
    public List<Long> findOverdueOrder() {
        return gameOrdersSimpleDao.findOverdueOrder();
    }

    @Override
    public Integer countConsumerByGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId) {
        return gameOrdersSimpleDao.countConsumerByGameConfigDuibaId(consumerId, gameConfigDuibaId);
    }

    @Override
    public Long countRow(Map<String, Object> paramMap) {
        return gameOrdersSimpleDao.countRow(paramMap);
    }

    @Override
    public List<GameOrdersSimpleDto> findByLimit(Map<String, Object> paramMap) {
        return BeanUtils.copyList(gameOrdersSimpleDao.findByLimit(paramMap),GameOrdersSimpleDto.class);
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids) {
        return BeanUtils.copyList(gameOrdersSimpleDao.countFailByOperatingActivityIds(ids),DeveloperActivityStatisticsDto.class);
    }

}
