package cn.com.duiba.activity.center.biz.service.guess.impl;


import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessAppSpecifyService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/7.
 */
@Service
public class DuibaGuessAppSpecifyServiceImpl implements DuibaGuessAppSpecifyService {
    @Resource
    private DuibaGuessAppSpecifyDao duibaGuessAppSpecifyDao;

    @Override
    public List<DuibaGuessAppSpecifyDto> findByDuibaGuessId(Long duibaGuessId) {
        return BeanUtils.copyList(duibaGuessAppSpecifyDao.findByDuibaGuessId(duibaGuessId),DuibaGuessAppSpecifyDto.class);
    }

    @Override
    public void delete(Long id) {
        duibaGuessAppSpecifyDao.delete(id);
    }

    @Override
    public void insert(DuibaGuessAppSpecifyDto duibaGuessAppSpecify) {
        DuibaGuessAppSpecifyEntity entity=BeanUtils.copy(duibaGuessAppSpecify,DuibaGuessAppSpecifyEntity.class);
        duibaGuessAppSpecifyDao.insert(entity);
        duibaGuessAppSpecify.setId(entity.getId());
    }

    @Override
    public DuibaGuessAppSpecifyDto findByDuibaGuessAndApp(Long duibaGuessId, Long appId) {
        return BeanUtils.copy(duibaGuessAppSpecifyDao.findByDuibaGuessAndApp(duibaGuessId, appId),DuibaGuessAppSpecifyDto.class);
    }

    @Override
    public DuibaGuessAppSpecifyDto find(Long id) {
        return BeanUtils.copy(duibaGuessAppSpecifyDao.find(id),DuibaGuessAppSpecifyDto.class);
    }
}
