package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrderTextChangeDao;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersSequenceDao;
import cn.com.duiba.activity.center.biz.entity.guess.GuessOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.GuessMQSend;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrderTextChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class GuessOrderTextChangeServiceImpl implements GuessOrderTextChangeService {

    @Autowired
    private GuessOrderTextChangeDao guessOrderTextChangeDao;

    @Autowired
    private GuessOrdersSequenceDao guessOrdersSequenceDao;

    @Autowired
    private GuessMQSend guessMQSend;

    /**
     * 添加竞猜订单
     *
     * @param guessOrdersDto
     */
    @Override
    public void insert(GuessOrdersDto guessOrdersDto) {
        Long id = guessOrdersSequenceDao.getId();
        int ret=guessOrderTextChangeDao.insert(BeanUtils.copy(guessOrdersDto, GuessOrdersEntity.class),id);
        guessOrdersDto.setId(id);
        if(ret==1){
            guessMQSend.guessSendDataSync(guessOrdersDto.getConsumerId(), guessOrdersDto.getId());
        }
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        int ret=guessOrderTextChangeDao.updateDeveloperBizId(consumerId,id,bizId);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        int ret=guessOrderTextChangeDao.updateMainOrderId(consumerId,id,mainOrderId,mainOrderNum);
        if(ret==1){
            guessMQSend.guessSendDataSync(consumerId, id);
        }
        return ret;
    }
}
