package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersAppDao;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersAppService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/7/27.
 */
@Service
public class GuessOrdersAppServiceImpl implements GuessOrdersAppService {

    @Autowired
    private GuessOrdersAppDao guessOrdersAppDao;
    @Override
    public List<GuessOrdersDto> findByLimit(Map<String, Object> queryMap) {
        return BeanUtils.copyList(guessOrdersAppDao.findByLimit(queryMap),GuessOrdersDto.class);
    }

    @Override
    public Long totalCount(Map<String, Object> queryMap) {
        return guessOrdersAppDao.totalCount(queryMap);
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids, Long appId) {
        return BeanUtils.copyList(guessOrdersAppDao.countFailByOperatingActivityIds(ids,appId),DeveloperActivityStatisticsDto.class);
    }
}
