package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.AppHdtoolOrdersDao;
import cn.com.duiba.activity.center.biz.service.hdtool.AppHdtoolOrdersService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/30.
 */
@Service
public class AppHdtoolOrdersServiceImpl implements AppHdtoolOrdersService {
    @Resource
    private AppHdtoolOrdersDao appHdtoolOrdersDao;

    @Override
    public HdtoolOrdersDto find(Long appId, Long id) {
        return BeanUtils.copy(appHdtoolOrdersDao.find(appId, id), HdtoolOrdersDto.class);
    }

    @Override
    public HdtoolOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        return BeanUtils.copy(appHdtoolOrdersDao.findByAppAndDeveloperBizId(appId, bizId), HdtoolOrdersDto.class);
    }

    @Override
    public List<HdtoolOrdersDto> findHdtoolOrderLimit50(Long appId, Long activityId) {
        return BeanUtils.copyList(appHdtoolOrdersDao.findHdtoolOrderLimit50(appId, activityId), HdtoolOrdersDto.class);
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(Long appId, List<Long> ids) {
        return BeanUtils.copyList(appHdtoolOrdersDao.countFailByOperatingActivityIds(appId, ids), DeveloperActivityStatisticsDto.class);
    }

    @Override
    public List<HdtoolOrdersDto> findByLimit(Map<String, Object> queryParam) {
        return BeanUtils.copyList(appHdtoolOrdersDao.findByLimit(queryParam), HdtoolOrdersDto.class);
    }

    @Override
    public Long totalCount(Map<String, Object> queryParam) {
        return appHdtoolOrdersDao.totalCount(queryParam);
    }

    @Override
    public List<HdtoolOrdersDto> findByIds(Long appId, List<Long> ids) {
        return BeanUtils.copyList(appHdtoolOrdersDao.findByIds(appId, ids), HdtoolOrdersDto.class);
    }

}
